/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "revision", "timestamp"})
public class OpenMetadataServerVersion {
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Software version of the OpenMetadata Server")
    private String version;
    @JsonProperty(value="revision")
    @JsonPropertyDescription(value="Software revision of the OpenMetadata Server")
    private String revision;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public OpenMetadataServerVersion withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="revision")
    public String getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    public void setRevision(String revision) {
        this.revision = revision;
    }

    public OpenMetadataServerVersion withRevision(String revision) {
        this.revision = revision;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public OpenMetadataServerVersion withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenMetadataServerVersion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("revision");
        sb.append('=');
        sb.append(this.revision == null ? "<null>" : this.revision);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.revision == null ? 0 : this.revision.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenMetadataServerVersion)) {
            return false;
        }
        OpenMetadataServerVersion rhs = (OpenMetadataServerVersion)other;
        return (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.revision == rhs.revision || this.revision != null && this.revision.equals(rhs.revision)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

