/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.configuration.profiler;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.profiler.MetricType;
import org.openmetadata.schema.type.ColumnDataType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dataType", "metrics", "disabled"})
public class MetricConfigurationDefinition {
    @JsonProperty(value="dataType")
    @JsonPropertyDescription(value="This enum defines the type of data stored in a column.")
    private ColumnDataType dataType;
    @JsonProperty(value="metrics")
    @Valid
    private List<MetricType> metrics = new ArrayList<MetricType>();
    @JsonProperty(value="disabled")
    @JsonPropertyDescription(value="If true, the metric will not be computed for the data type.")
    private Boolean disabled = false;

    @JsonProperty(value="dataType")
    public ColumnDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(ColumnDataType dataType) {
        this.dataType = dataType;
    }

    public MetricConfigurationDefinition withDataType(ColumnDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty(value="metrics")
    public List<MetricType> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetrics(List<MetricType> metrics) {
        this.metrics = metrics;
    }

    public MetricConfigurationDefinition withMetrics(List<MetricType> metrics) {
        this.metrics = metrics;
        return this;
    }

    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public MetricConfigurationDefinition withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetricConfigurationDefinition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("metrics");
        sb.append('=');
        sb.append(this.metrics == null ? "<null>" : this.metrics);
        sb.append(',');
        sb.append("disabled");
        sb.append('=');
        sb.append(this.disabled == null ? "<null>" : this.disabled);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.disabled == null ? 0 : this.disabled.hashCode());
        result = result * 31 + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MetricConfigurationDefinition)) {
            return false;
        }
        MetricConfigurationDefinition rhs = (MetricConfigurationDefinition)other;
        return (this.disabled == rhs.disabled || this.disabled != null && this.disabled.equals(rhs.disabled)) && (this.metrics == rhs.metrics || this.metrics != null && this.metrics.equals(rhs.metrics)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType));
    }
}

