/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EnumInterface;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.DataModelType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "tags", "dataProducts", "owners", "service", "serviceType", "dataModelType", "sql", "columns", "project", "domain", "lifeCycle", "sourceHash", "extension"})
public class CreateDashboardDataModel
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this data model. It could be title or label from the source services.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this data model.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="List of fully qualified names of data products this entity is part of.")
    @Valid
    private List<String> dataProducts = new ArrayList<String>();
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    @NotNull
    private @Size(min=1, max=3072) @NotNull String service;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of Dashboard service - Superset, Looker, Redash, Tableau, Metabase, PowerBi, Mode, or Lightdash")
    private DashboardServiceType serviceType;
    @JsonProperty(value="dataModelType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of data models.")
    @NotNull
    private DataModelType dataModelType;
    @JsonProperty(value="sql")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String sql;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Columns from the data model.")
    @Valid
    @NotNull
    private List<Column> columns = null;
    @JsonProperty(value="project")
    @JsonPropertyDescription(value="Name of the project / workspace / collection in which the dataModel is contained")
    private String project;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Dashboard Data Model belongs to.")
    private String domain;
    @JsonProperty(value="lifeCycle")
    @JsonPropertyDescription(value="This schema defines Life Cycle Properties.")
    @Valid
    private LifeCycle lifeCycle;
    @JsonProperty(value="sourceHash")
    @JsonPropertyDescription(value="Source hash of the entity")
    @Size(min=1, max=32)
    private @Size(min=1, max=32) String sourceHash;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateDashboardDataModel withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateDashboardDataModel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDashboardDataModel withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateDashboardDataModel withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateDashboardDataModel withDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateDashboardDataModel withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateDashboardDataModel withService(String service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="serviceType")
    public DashboardServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(DashboardServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public CreateDashboardDataModel withServiceType(DashboardServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="dataModelType")
    public DataModelType getDataModelType() {
        return this.dataModelType;
    }

    @JsonProperty(value="dataModelType")
    public void setDataModelType(DataModelType dataModelType) {
        this.dataModelType = dataModelType;
    }

    public CreateDashboardDataModel withDataModelType(DataModelType dataModelType) {
        this.dataModelType = dataModelType;
        return this;
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="sql")
    public void setSql(String sql) {
        this.sql = sql;
    }

    public CreateDashboardDataModel withSql(String sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public CreateDashboardDataModel withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="project")
    public String getProject() {
        return this.project;
    }

    @JsonProperty(value="project")
    public void setProject(String project) {
        this.project = project;
    }

    public CreateDashboardDataModel withProject(String project) {
        this.project = project;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateDashboardDataModel withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="lifeCycle")
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateDashboardDataModel withLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @JsonProperty(value="sourceHash")
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public CreateDashboardDataModel withSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateDashboardDataModel withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateDashboardDataModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("dataModelType");
        sb.append('=');
        sb.append(this.dataModelType == null ? "<null>" : this.dataModelType);
        sb.append(',');
        sb.append("sql");
        sb.append('=');
        sb.append(this.sql == null ? "<null>" : this.sql);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("project");
        sb.append('=');
        sb.append(this.project == null ? "<null>" : this.project);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("lifeCycle");
        sb.append('=');
        sb.append(this.lifeCycle == null ? "<null>" : this.lifeCycle);
        sb.append(',');
        sb.append("sourceHash");
        sb.append('=');
        sb.append(this.sourceHash == null ? "<null>" : this.sourceHash);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.project == null ? 0 : this.project.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sql == null ? 0 : this.sql.hashCode());
        result = result * 31 + (this.sourceHash == null ? 0 : this.sourceHash.hashCode());
        result = result * 31 + (this.dataModelType == null ? 0 : this.dataModelType.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.lifeCycle == null ? 0 : this.lifeCycle.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateDashboardDataModel)) {
            return false;
        }
        CreateDashboardDataModel rhs = (CreateDashboardDataModel)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.project == rhs.project || this.project != null && this.project.equals(rhs.project)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sql == rhs.sql || this.sql != null && this.sql.equals(rhs.sql)) && (this.sourceHash == rhs.sourceHash || this.sourceHash != null && this.sourceHash.equals(rhs.sourceHash)) && (this.dataModelType == rhs.dataModelType || this.dataModelType != null && this.dataModelType.equals((Object)rhs.dataModelType)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.lifeCycle == rhs.lifeCycle || this.lifeCycle != null && this.lifeCycle.equals(rhs.lifeCycle));
    }

    public static enum DashboardServiceType implements EnumInterface
    {
        Superset("Superset"),
        Looker("Looker"),
        Tableau("Tableau"),
        Redash("Redash"),
        Metabase("Metabase"),
        PowerBI("PowerBI"),
        PowerBIReportServer("PowerBIReportServer"),
        Mode("Mode"),
        CustomDashboard("CustomDashboard"),
        DomoDashboard("DomoDashboard"),
        QuickSight("QuickSight"),
        QlikSense("QlikSense"),
        Lightdash("Lightdash"),
        Mstr("Mstr"),
        QlikCloud("QlikCloud");

        private final String value;
        private static final Map<String, DashboardServiceType> CONSTANTS;

        private DashboardServiceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardServiceType fromValue(String value) {
            DashboardServiceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DashboardServiceType>();
            for (DashboardServiceType c : DashboardServiceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

