/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "reviewers", "owners", "tags", "provider", "mutuallyExclusive", "domain", "extension"})
public class CreateGlossary
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this glossary.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="reviewers")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> reviewers = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this glossary")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="mutuallyExclusive")
    @JsonPropertyDescription(value="Glossary terms that are direct children in this glossary are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.")
    private Boolean mutuallyExclusive = false;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Glossary belongs to.")
    private String domain;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateGlossary withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateGlossary withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateGlossary withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="reviewers")
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateGlossary withReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateGlossary withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateGlossary withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public CreateGlossary withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="mutuallyExclusive")
    public Boolean getMutuallyExclusive() {
        return this.mutuallyExclusive;
    }

    @JsonProperty(value="mutuallyExclusive")
    public void setMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
    }

    public CreateGlossary withMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateGlossary withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateGlossary withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateGlossary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("reviewers");
        sb.append('=');
        sb.append(this.reviewers == null ? "<null>" : this.reviewers);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("mutuallyExclusive");
        sb.append('=');
        sb.append(this.mutuallyExclusive == null ? "<null>" : this.mutuallyExclusive);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.mutuallyExclusive == null ? 0 : this.mutuallyExclusive.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.reviewers == null ? 0 : this.reviewers.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateGlossary)) {
            return false;
        }
        CreateGlossary rhs = (CreateGlossary)other;
        return (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.mutuallyExclusive == rhs.mutuallyExclusive || this.mutuallyExclusive != null && this.mutuallyExclusive.equals(rhs.mutuallyExclusive)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.reviewers == rhs.reviewers || this.reviewers != null && this.reviewers.equals(rhs.reviewers)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

