/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.TermReference;
import org.openmetadata.schema.entity.type.Style;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"glossary", "parent", "name", "displayName", "description", "style", "synonyms", "relatedTerms", "references", "reviewers", "owners", "tags", "provider", "mutuallyExclusive", "extension"})
public class CreateGlossaryTerm
implements CreateEntity {
    @JsonProperty(value="glossary")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    @NotNull
    private @Size(min=1, max=3072) @NotNull String glossary;
    @JsonProperty(value="parent")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String parent;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this glossary term.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="style")
    @JsonPropertyDescription(value="UI Style is used to associate a color code and/or icon to entity to customize the look of that entity in UI.")
    @Valid
    private Style style;
    @JsonProperty(value="synonyms")
    @JsonPropertyDescription(value="Alternate names that are synonyms or near-synonyms for the glossary term.")
    @Valid
    private List<String> synonyms = new ArrayList<String>();
    @JsonProperty(value="relatedTerms")
    @JsonPropertyDescription(value="Other array of glossary term fully qualified names that are related to this glossary term.")
    @Valid
    private List<String> relatedTerms = new ArrayList<String>();
    @JsonProperty(value="references")
    @JsonPropertyDescription(value="Link to a reference from an external glossary.")
    @Valid
    private List<TermReference> references = new ArrayList<TermReference>();
    @JsonProperty(value="reviewers")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> reviewers = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this glossary term.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="mutuallyExclusive")
    @JsonPropertyDescription(value="Glossary terms that are children of this term are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity from this group. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.")
    private Boolean mutuallyExclusive = false;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @JsonProperty(value="glossary")
    public String getGlossary() {
        return this.glossary;
    }

    @JsonProperty(value="glossary")
    public void setGlossary(String glossary) {
        this.glossary = glossary;
    }

    public CreateGlossaryTerm withGlossary(String glossary) {
        this.glossary = glossary;
        return this;
    }

    @JsonProperty(value="parent")
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    public CreateGlossaryTerm withParent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateGlossaryTerm withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateGlossaryTerm withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateGlossaryTerm withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="style")
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    public void setStyle(Style style) {
        this.style = style;
    }

    public CreateGlossaryTerm withStyle(Style style) {
        this.style = style;
        return this;
    }

    @JsonProperty(value="synonyms")
    public List<String> getSynonyms() {
        return this.synonyms;
    }

    @JsonProperty(value="synonyms")
    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }

    public CreateGlossaryTerm withSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    @JsonProperty(value="relatedTerms")
    public List<String> getRelatedTerms() {
        return this.relatedTerms;
    }

    @JsonProperty(value="relatedTerms")
    public void setRelatedTerms(List<String> relatedTerms) {
        this.relatedTerms = relatedTerms;
    }

    public CreateGlossaryTerm withRelatedTerms(List<String> relatedTerms) {
        this.relatedTerms = relatedTerms;
        return this;
    }

    @JsonProperty(value="references")
    public List<TermReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<TermReference> references) {
        this.references = references;
    }

    public CreateGlossaryTerm withReferences(List<TermReference> references) {
        this.references = references;
        return this;
    }

    @Override
    @JsonProperty(value="reviewers")
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateGlossaryTerm withReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateGlossaryTerm withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateGlossaryTerm withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public CreateGlossaryTerm withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="mutuallyExclusive")
    public Boolean getMutuallyExclusive() {
        return this.mutuallyExclusive;
    }

    @JsonProperty(value="mutuallyExclusive")
    public void setMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
    }

    public CreateGlossaryTerm withMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateGlossaryTerm withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateGlossaryTerm.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("glossary");
        sb.append('=');
        sb.append(this.glossary == null ? "<null>" : this.glossary);
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(this.parent == null ? "<null>" : this.parent);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(this.style == null ? "<null>" : this.style);
        sb.append(',');
        sb.append("synonyms");
        sb.append('=');
        sb.append(this.synonyms == null ? "<null>" : this.synonyms);
        sb.append(',');
        sb.append("relatedTerms");
        sb.append('=');
        sb.append(this.relatedTerms == null ? "<null>" : this.relatedTerms);
        sb.append(',');
        sb.append("references");
        sb.append('=');
        sb.append(this.references == null ? "<null>" : this.references);
        sb.append(',');
        sb.append("reviewers");
        sb.append('=');
        sb.append(this.reviewers == null ? "<null>" : this.reviewers);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("mutuallyExclusive");
        sb.append('=');
        sb.append(this.mutuallyExclusive == null ? "<null>" : this.mutuallyExclusive);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.parent == null ? 0 : this.parent.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.references == null ? 0 : this.references.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.synonyms == null ? 0 : this.synonyms.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.relatedTerms == null ? 0 : this.relatedTerms.hashCode());
        result = result * 31 + (this.reviewers == null ? 0 : this.reviewers.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.glossary == null ? 0 : this.glossary.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.mutuallyExclusive == null ? 0 : this.mutuallyExclusive.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateGlossaryTerm)) {
            return false;
        }
        CreateGlossaryTerm rhs = (CreateGlossaryTerm)other;
        return (this.parent == rhs.parent || this.parent != null && this.parent.equals(rhs.parent)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.references == rhs.references || this.references != null && this.references.equals(rhs.references)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.synonyms == rhs.synonyms || this.synonyms != null && this.synonyms.equals(rhs.synonyms)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.relatedTerms == rhs.relatedTerms || this.relatedTerms != null && this.relatedTerms.equals(rhs.relatedTerms)) && (this.reviewers == rhs.reviewers || this.reviewers != null && this.reviewers.equals(rhs.reviewers)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.glossary == rhs.glossary || this.glossary != null && this.glossary.equals(rhs.glossary)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.mutuallyExclusive == rhs.mutuallyExclusive || this.mutuallyExclusive != null && this.mutuallyExclusive.equals(rhs.mutuallyExclusive)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.style == rhs.style || this.style != null && this.style.equals(rhs.style));
    }
}

