/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.MlFeature;
import org.openmetadata.schema.type.MlHyperParameter;
import org.openmetadata.schema.type.MlStore;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "algorithm", "mlFeatures", "target", "mlHyperParameters", "dashboard", "mlStore", "server", "tags", "owners", "service", "extension", "sourceUrl", "domain", "dataProducts", "lifeCycle", "sourceHash"})
public class CreateMlModel
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this ML model. It could be title or label from the source services")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="algorithm")
    @JsonPropertyDescription(value="Algorithm used to train the ML Model")
    private String algorithm = "mlmodel";
    @JsonProperty(value="mlFeatures")
    @JsonPropertyDescription(value="Features used to train the ML Model.")
    @Valid
    private List<MlFeature> mlFeatures = null;
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) String target;
    @JsonProperty(value="mlHyperParameters")
    @JsonPropertyDescription(value="Hyper Parameters used to train the ML Model.")
    @Valid
    private List<MlHyperParameter> mlHyperParameters = null;
    @JsonProperty(value="dashboard")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String dashboard;
    @JsonProperty(value="mlStore")
    @JsonPropertyDescription(value="Location containing the ML Model. It can be a storage layer and/or a container repository.")
    @Valid
    private MlStore mlStore;
    @JsonProperty(value="server")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI server;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this ML Model")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    @NotNull
    private @Size(min=1, max=3072) @NotNull String service;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;
    @JsonProperty(value="sourceUrl")
    @JsonPropertyDescription(value="Source Url of the respective entity.")
    private String sourceUrl;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the MLModel belongs to.")
    private String domain;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="List of fully qualified names of data products this entity is part of.")
    @Valid
    private List<String> dataProducts = new ArrayList<String>();
    @JsonProperty(value="lifeCycle")
    @JsonPropertyDescription(value="This schema defines Life Cycle Properties.")
    @Valid
    private LifeCycle lifeCycle;
    @JsonProperty(value="sourceHash")
    @JsonPropertyDescription(value="Source hash of the entity")
    @Size(min=1, max=32)
    private @Size(min=1, max=32) String sourceHash;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateMlModel withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateMlModel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMlModel withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public CreateMlModel withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="mlFeatures")
    public List<MlFeature> getMlFeatures() {
        return this.mlFeatures;
    }

    @JsonProperty(value="mlFeatures")
    public void setMlFeatures(List<MlFeature> mlFeatures) {
        this.mlFeatures = mlFeatures;
    }

    public CreateMlModel withMlFeatures(List<MlFeature> mlFeatures) {
        this.mlFeatures = mlFeatures;
        return this;
    }

    @JsonProperty(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    public CreateMlModel withTarget(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="mlHyperParameters")
    public List<MlHyperParameter> getMlHyperParameters() {
        return this.mlHyperParameters;
    }

    @JsonProperty(value="mlHyperParameters")
    public void setMlHyperParameters(List<MlHyperParameter> mlHyperParameters) {
        this.mlHyperParameters = mlHyperParameters;
    }

    public CreateMlModel withMlHyperParameters(List<MlHyperParameter> mlHyperParameters) {
        this.mlHyperParameters = mlHyperParameters;
        return this;
    }

    @JsonProperty(value="dashboard")
    public String getDashboard() {
        return this.dashboard;
    }

    @JsonProperty(value="dashboard")
    public void setDashboard(String dashboard) {
        this.dashboard = dashboard;
    }

    public CreateMlModel withDashboard(String dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    @JsonProperty(value="mlStore")
    public MlStore getMlStore() {
        return this.mlStore;
    }

    @JsonProperty(value="mlStore")
    public void setMlStore(MlStore mlStore) {
        this.mlStore = mlStore;
    }

    public CreateMlModel withMlStore(MlStore mlStore) {
        this.mlStore = mlStore;
        return this;
    }

    @JsonProperty(value="server")
    public URI getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServer(URI server) {
        this.server = server;
    }

    public CreateMlModel withServer(URI server) {
        this.server = server;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateMlModel withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateMlModel withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateMlModel withService(String service) {
        this.service = service;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateMlModel withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    @JsonProperty(value="sourceUrl")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateMlModel withSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateMlModel withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateMlModel withDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    @Override
    @JsonProperty(value="lifeCycle")
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateMlModel withLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @JsonProperty(value="sourceHash")
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public CreateMlModel withSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateMlModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("algorithm");
        sb.append('=');
        sb.append(this.algorithm == null ? "<null>" : this.algorithm);
        sb.append(',');
        sb.append("mlFeatures");
        sb.append('=');
        sb.append(this.mlFeatures == null ? "<null>" : this.mlFeatures);
        sb.append(',');
        sb.append("target");
        sb.append('=');
        sb.append(this.target == null ? "<null>" : this.target);
        sb.append(',');
        sb.append("mlHyperParameters");
        sb.append('=');
        sb.append(this.mlHyperParameters == null ? "<null>" : this.mlHyperParameters);
        sb.append(',');
        sb.append("dashboard");
        sb.append('=');
        sb.append(this.dashboard == null ? "<null>" : this.dashboard);
        sb.append(',');
        sb.append("mlStore");
        sb.append('=');
        sb.append(this.mlStore == null ? "<null>" : this.mlStore);
        sb.append(',');
        sb.append("server");
        sb.append('=');
        sb.append(this.server == null ? "<null>" : this.server);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        sb.append("lifeCycle");
        sb.append('=');
        sb.append(this.lifeCycle == null ? "<null>" : this.lifeCycle);
        sb.append(',');
        sb.append("sourceHash");
        sb.append('=');
        sb.append(this.sourceHash == null ? "<null>" : this.sourceHash);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.server == null ? 0 : this.server.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.mlHyperParameters == null ? 0 : this.mlHyperParameters.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.target == null ? 0 : this.target.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.sourceHash == null ? 0 : this.sourceHash.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.mlFeatures == null ? 0 : this.mlFeatures.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.mlStore == null ? 0 : this.mlStore.hashCode());
        result = result * 31 + (this.lifeCycle == null ? 0 : this.lifeCycle.hashCode());
        result = result * 31 + (this.dashboard == null ? 0 : this.dashboard.hashCode());
        result = result * 31 + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateMlModel)) {
            return false;
        }
        CreateMlModel rhs = (CreateMlModel)other;
        return (this.server == rhs.server || this.server != null && this.server.equals(rhs.server)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.mlHyperParameters == rhs.mlHyperParameters || this.mlHyperParameters != null && this.mlHyperParameters.equals(rhs.mlHyperParameters)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.target == rhs.target || this.target != null && this.target.equals(rhs.target)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.sourceHash == rhs.sourceHash || this.sourceHash != null && this.sourceHash.equals(rhs.sourceHash)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.mlFeatures == rhs.mlFeatures || this.mlFeatures != null && this.mlFeatures.equals(rhs.mlFeatures)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.mlStore == rhs.mlStore || this.mlStore != null && this.mlStore.equals(rhs.mlStore)) && (this.lifeCycle == rhs.lifeCycle || this.lifeCycle != null && this.lifeCycle.equals(rhs.lifeCycle)) && (this.dashboard == rhs.dashboard || this.dashboard != null && this.dashboard.equals(rhs.dashboard)) && (this.algorithm == rhs.algorithm || this.algorithm != null && this.algorithm.equals(rhs.algorithm));
    }
}

