/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owners", "tags", "query", "query_type", "exclude_usage", "duration", "users", "usedBy", "dialect", "queryDate", "queryUsedIn", "triggeredBy", "processedLineage", "service", "domain"})
public class CreateQuery
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this query.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this Query")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="query")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    @NotNull
    private String query;
    @JsonProperty(value="query_type")
    @JsonPropertyDescription(value="SQL query type")
    private String queryType;
    @JsonProperty(value="exclude_usage")
    @JsonPropertyDescription(value="Flag to check if query is to be excluded while processing usage")
    private Boolean excludeUsage;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="How long did the query took to run in milliseconds.")
    private Double duration;
    @JsonProperty(value="users")
    @JsonPropertyDescription(value="UserName of the user running the query.")
    @Valid
    private List<String> users = new ArrayList<String>();
    @JsonProperty(value="usedBy")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of users who ran the query but does not exist in OpenMetadata.")
    @Valid
    private Set<String> usedBy = new LinkedHashSet<String>();
    @JsonProperty(value="dialect")
    @JsonPropertyDescription(value="SQL dialect.")
    private String dialect;
    @JsonProperty(value="queryDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long queryDate;
    @JsonProperty(value="queryUsedIn")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> queryUsedIn = null;
    @JsonProperty(value="triggeredBy")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference triggeredBy;
    @JsonProperty(value="processedLineage")
    @JsonPropertyDescription(value="Flag if this query has already been successfully processed for lineage")
    private Boolean processedLineage = false;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    @NotNull
    private @Size(min=1, max=3072) @NotNull String service;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateQuery withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateQuery withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateQuery withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateQuery withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateQuery withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    public CreateQuery withQuery(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query_type")
    public String getQueryType() {
        return this.queryType;
    }

    @JsonProperty(value="query_type")
    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public CreateQuery withQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    @JsonProperty(value="exclude_usage")
    public Boolean getExcludeUsage() {
        return this.excludeUsage;
    }

    @JsonProperty(value="exclude_usage")
    public void setExcludeUsage(Boolean excludeUsage) {
        this.excludeUsage = excludeUsage;
    }

    public CreateQuery withExcludeUsage(Boolean excludeUsage) {
        this.excludeUsage = excludeUsage;
        return this;
    }

    @JsonProperty(value="duration")
    public Double getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public CreateQuery withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="users")
    public List<String> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    public CreateQuery withUsers(List<String> users) {
        this.users = users;
        return this;
    }

    @JsonProperty(value="usedBy")
    public Set<String> getUsedBy() {
        return this.usedBy;
    }

    @JsonProperty(value="usedBy")
    public void setUsedBy(Set<String> usedBy) {
        this.usedBy = usedBy;
    }

    public CreateQuery withUsedBy(Set<String> usedBy) {
        this.usedBy = usedBy;
        return this;
    }

    @JsonProperty(value="dialect")
    public String getDialect() {
        return this.dialect;
    }

    @JsonProperty(value="dialect")
    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public CreateQuery withDialect(String dialect) {
        this.dialect = dialect;
        return this;
    }

    @JsonProperty(value="queryDate")
    public Long getQueryDate() {
        return this.queryDate;
    }

    @JsonProperty(value="queryDate")
    public void setQueryDate(Long queryDate) {
        this.queryDate = queryDate;
    }

    public CreateQuery withQueryDate(Long queryDate) {
        this.queryDate = queryDate;
        return this;
    }

    @JsonProperty(value="queryUsedIn")
    public List<EntityReference> getQueryUsedIn() {
        return this.queryUsedIn;
    }

    @JsonProperty(value="queryUsedIn")
    public void setQueryUsedIn(List<EntityReference> queryUsedIn) {
        this.queryUsedIn = queryUsedIn;
    }

    public CreateQuery withQueryUsedIn(List<EntityReference> queryUsedIn) {
        this.queryUsedIn = queryUsedIn;
        return this;
    }

    @JsonProperty(value="triggeredBy")
    public EntityReference getTriggeredBy() {
        return this.triggeredBy;
    }

    @JsonProperty(value="triggeredBy")
    public void setTriggeredBy(EntityReference triggeredBy) {
        this.triggeredBy = triggeredBy;
    }

    public CreateQuery withTriggeredBy(EntityReference triggeredBy) {
        this.triggeredBy = triggeredBy;
        return this;
    }

    @JsonProperty(value="processedLineage")
    public Boolean getProcessedLineage() {
        return this.processedLineage;
    }

    @JsonProperty(value="processedLineage")
    public void setProcessedLineage(Boolean processedLineage) {
        this.processedLineage = processedLineage;
    }

    public CreateQuery withProcessedLineage(Boolean processedLineage) {
        this.processedLineage = processedLineage;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateQuery withService(String service) {
        this.service = service;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateQuery withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("query");
        sb.append('=');
        sb.append(this.query == null ? "<null>" : this.query);
        sb.append(',');
        sb.append("queryType");
        sb.append('=');
        sb.append(this.queryType == null ? "<null>" : this.queryType);
        sb.append(',');
        sb.append("excludeUsage");
        sb.append('=');
        sb.append(this.excludeUsage == null ? "<null>" : this.excludeUsage);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(this.users == null ? "<null>" : this.users);
        sb.append(',');
        sb.append("usedBy");
        sb.append('=');
        sb.append(this.usedBy == null ? "<null>" : this.usedBy);
        sb.append(',');
        sb.append("dialect");
        sb.append('=');
        sb.append(this.dialect == null ? "<null>" : this.dialect);
        sb.append(',');
        sb.append("queryDate");
        sb.append('=');
        sb.append(this.queryDate == null ? "<null>" : this.queryDate);
        sb.append(',');
        sb.append("queryUsedIn");
        sb.append('=');
        sb.append(this.queryUsedIn == null ? "<null>" : this.queryUsedIn);
        sb.append(',');
        sb.append("triggeredBy");
        sb.append('=');
        sb.append(this.triggeredBy == null ? "<null>" : this.triggeredBy);
        sb.append(',');
        sb.append("processedLineage");
        sb.append('=');
        sb.append(this.processedLineage == null ? "<null>" : this.processedLineage);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.queryUsedIn == null ? 0 : this.queryUsedIn.hashCode());
        result = result * 31 + (this.excludeUsage == null ? 0 : this.excludeUsage.hashCode());
        result = result * 31 + (this.dialect == null ? 0 : this.dialect.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.query == null ? 0 : this.query.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.users == null ? 0 : this.users.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.queryType == null ? 0 : this.queryType.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.queryDate == null ? 0 : this.queryDate.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.processedLineage == null ? 0 : this.processedLineage.hashCode());
        result = result * 31 + (this.usedBy == null ? 0 : this.usedBy.hashCode());
        result = result * 31 + (this.triggeredBy == null ? 0 : this.triggeredBy.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateQuery)) {
            return false;
        }
        CreateQuery rhs = (CreateQuery)other;
        return (this.queryUsedIn == rhs.queryUsedIn || this.queryUsedIn != null && this.queryUsedIn.equals(rhs.queryUsedIn)) && (this.excludeUsage == rhs.excludeUsage || this.excludeUsage != null && this.excludeUsage.equals(rhs.excludeUsage)) && (this.dialect == rhs.dialect || this.dialect != null && this.dialect.equals(rhs.dialect)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.query == rhs.query || this.query != null && this.query.equals(rhs.query)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.users == rhs.users || this.users != null && this.users.equals(rhs.users)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.queryType == rhs.queryType || this.queryType != null && this.queryType.equals(rhs.queryType)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.queryDate == rhs.queryDate || this.queryDate != null && this.queryDate.equals(rhs.queryDate)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.processedLineage == rhs.processedLineage || this.processedLineage != null && this.processedLineage.equals(rhs.processedLineage)) && (this.usedBy == rhs.usedBy || this.usedBy != null && this.usedBy.equals(rhs.usedBy)) && (this.triggeredBy == rhs.triggeredBy || this.triggeredBy != null && this.triggeredBy.equals(rhs.triggeredBy));
    }
}

