/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.DataModel;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TablePartition;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.schema.type.TableType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "tableType", "columns", "dataModel", "locationPath", "tableConstraints", "tablePartition", "tableProfilerConfig", "owners", "databaseSchema", "tags", "schemaDefinition", "retentionPeriod", "extension", "sourceUrl", "domain", "dataProducts", "fileFormat", "lifeCycle", "sourceHash"})
public class CreateTable
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this table.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="tableType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of tables.")
    private TableType tableType;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Name of the tables in the database")
    @Valid
    @NotNull
    private List<Column> columns = null;
    @JsonProperty(value="dataModel")
    @JsonPropertyDescription(value="This captures information about how the table is modeled. Currently only DBT and DDL model is supported.")
    @Valid
    private DataModel dataModel;
    @JsonProperty(value="locationPath")
    @JsonPropertyDescription(value="Full storage path in case of external and managed tables.")
    private String locationPath = null;
    @JsonProperty(value="tableConstraints")
    @Valid
    private List<TableConstraint> tableConstraints = null;
    @JsonProperty(value="tablePartition")
    @JsonPropertyDescription(value="This schema defines the partition column of a table and format the partition is created.")
    @Valid
    private TablePartition tablePartition;
    @JsonProperty(value="tableProfilerConfig")
    @JsonPropertyDescription(value="This schema defines the type for Table profile config.")
    @Valid
    private TableProfilerConfig tableProfilerConfig;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    @NotNull
    private @Size(min=1, max=3072) @NotNull String databaseSchema;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this table")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="schemaDefinition")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String schemaDefinition;
    @JsonProperty(value="retentionPeriod")
    @JsonPropertyDescription(value="Duration in ISO 8601 format in UTC. Example - 'P23DT23H'.")
    private String retentionPeriod;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;
    @JsonProperty(value="sourceUrl")
    @JsonPropertyDescription(value="Source Url of the respective entity.")
    private String sourceUrl;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="List of fully qualified names of data products this entity is part of.")
    @Valid
    private List<String> dataProducts = new ArrayList<String>();
    @JsonProperty(value="fileFormat")
    @JsonPropertyDescription(value="File format in case of file/datalake tables.")
    private FileFormat fileFormat;
    @JsonProperty(value="lifeCycle")
    @JsonPropertyDescription(value="This schema defines Life Cycle Properties.")
    @Valid
    private LifeCycle lifeCycle;
    @JsonProperty(value="sourceHash")
    @JsonPropertyDescription(value="Source hash of the entity")
    @Size(min=1, max=32)
    private @Size(min=1, max=32) String sourceHash;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateTable withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTable withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTable withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="tableType")
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="tableType")
    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public CreateTable withTableType(TableType tableType) {
        this.tableType = tableType;
        return this;
    }

    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public CreateTable withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="dataModel")
    public DataModel getDataModel() {
        return this.dataModel;
    }

    @JsonProperty(value="dataModel")
    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public CreateTable withDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
        return this;
    }

    @JsonProperty(value="locationPath")
    public String getLocationPath() {
        return this.locationPath;
    }

    @JsonProperty(value="locationPath")
    public void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
    }

    public CreateTable withLocationPath(String locationPath) {
        this.locationPath = locationPath;
        return this;
    }

    @JsonProperty(value="tableConstraints")
    public List<TableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    @JsonProperty(value="tableConstraints")
    public void setTableConstraints(List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
    }

    public CreateTable withTableConstraints(List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
        return this;
    }

    @JsonProperty(value="tablePartition")
    public TablePartition getTablePartition() {
        return this.tablePartition;
    }

    @JsonProperty(value="tablePartition")
    public void setTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    public CreateTable withTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
        return this;
    }

    @JsonProperty(value="tableProfilerConfig")
    public TableProfilerConfig getTableProfilerConfig() {
        return this.tableProfilerConfig;
    }

    @JsonProperty(value="tableProfilerConfig")
    public void setTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
    }

    public CreateTable withTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateTable withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public CreateTable withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateTable withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="schemaDefinition")
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @JsonProperty(value="schemaDefinition")
    public void setSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    public CreateTable withSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
        return this;
    }

    @JsonProperty(value="retentionPeriod")
    public String getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @JsonProperty(value="retentionPeriod")
    public void setRetentionPeriod(String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public CreateTable withRetentionPeriod(String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateTable withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    @JsonProperty(value="sourceUrl")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateTable withSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateTable withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateTable withDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    @JsonProperty(value="fileFormat")
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="fileFormat")
    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public CreateTable withFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Override
    @JsonProperty(value="lifeCycle")
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateTable withLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @JsonProperty(value="sourceHash")
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public CreateTable withSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTable.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tableType");
        sb.append('=');
        sb.append(this.tableType == null ? "<null>" : this.tableType);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("dataModel");
        sb.append('=');
        sb.append(this.dataModel == null ? "<null>" : this.dataModel);
        sb.append(',');
        sb.append("locationPath");
        sb.append('=');
        sb.append(this.locationPath == null ? "<null>" : this.locationPath);
        sb.append(',');
        sb.append("tableConstraints");
        sb.append('=');
        sb.append(this.tableConstraints == null ? "<null>" : this.tableConstraints);
        sb.append(',');
        sb.append("tablePartition");
        sb.append('=');
        sb.append(this.tablePartition == null ? "<null>" : this.tablePartition);
        sb.append(',');
        sb.append("tableProfilerConfig");
        sb.append('=');
        sb.append(this.tableProfilerConfig == null ? "<null>" : this.tableProfilerConfig);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("schemaDefinition");
        sb.append('=');
        sb.append(this.schemaDefinition == null ? "<null>" : this.schemaDefinition);
        sb.append(',');
        sb.append("retentionPeriod");
        sb.append('=');
        sb.append(this.retentionPeriod == null ? "<null>" : this.retentionPeriod);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        sb.append("fileFormat");
        sb.append('=');
        sb.append(this.fileFormat == null ? "<null>" : this.fileFormat);
        sb.append(',');
        sb.append("lifeCycle");
        sb.append('=');
        sb.append(this.lifeCycle == null ? "<null>" : this.lifeCycle);
        sb.append(',');
        sb.append("sourceHash");
        sb.append('=');
        sb.append(this.sourceHash == null ? "<null>" : this.sourceHash);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.schemaDefinition == null ? 0 : this.schemaDefinition.hashCode());
        result = result * 31 + (this.dataModel == null ? 0 : this.dataModel.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.tableConstraints == null ? 0 : this.tableConstraints.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.tableType == null ? 0 : this.tableType.hashCode());
        result = result * 31 + (this.sourceHash == null ? 0 : this.sourceHash.hashCode());
        result = result * 31 + (this.tableProfilerConfig == null ? 0 : this.tableProfilerConfig.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.tablePartition == null ? 0 : this.tablePartition.hashCode());
        result = result * 31 + (this.lifeCycle == null ? 0 : this.lifeCycle.hashCode());
        result = result * 31 + (this.locationPath == null ? 0 : this.locationPath.hashCode());
        result = result * 31 + (this.fileFormat == null ? 0 : this.fileFormat.hashCode());
        result = result * 31 + (this.retentionPeriod == null ? 0 : this.retentionPeriod.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTable)) {
            return false;
        }
        CreateTable rhs = (CreateTable)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.schemaDefinition == rhs.schemaDefinition || this.schemaDefinition != null && this.schemaDefinition.equals(rhs.schemaDefinition)) && (this.dataModel == rhs.dataModel || this.dataModel != null && this.dataModel.equals(rhs.dataModel)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.tableConstraints == rhs.tableConstraints || this.tableConstraints != null && this.tableConstraints.equals(rhs.tableConstraints)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.tableType == rhs.tableType || this.tableType != null && this.tableType.equals((Object)rhs.tableType)) && (this.sourceHash == rhs.sourceHash || this.sourceHash != null && this.sourceHash.equals(rhs.sourceHash)) && (this.tableProfilerConfig == rhs.tableProfilerConfig || this.tableProfilerConfig != null && this.tableProfilerConfig.equals(rhs.tableProfilerConfig)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.tablePartition == rhs.tablePartition || this.tablePartition != null && this.tablePartition.equals(rhs.tablePartition)) && (this.lifeCycle == rhs.lifeCycle || this.lifeCycle != null && this.lifeCycle.equals(rhs.lifeCycle)) && (this.locationPath == rhs.locationPath || this.locationPath != null && this.locationPath.equals(rhs.locationPath)) && (this.fileFormat == rhs.fileFormat || this.fileFormat != null && this.fileFormat.equals((Object)rhs.fileFormat)) && (this.retentionPeriod == rhs.retentionPeriod || this.retentionPeriod != null && this.retentionPeriod.equals(rhs.retentionPeriod));
    }

    public static enum FileFormat {
        CSV("csv"),
        TSV("tsv"),
        AVRO("avro"),
        PARQUET("parquet"),
        JSON("json"),
        JSON_GZ("json.gz"),
        JSON_ZIP("json.zip"),
        JSONL("jsonl"),
        JSONL_GZ("jsonl.gz"),
        JSONL_ZIP("jsonl.zip");

        private final String value;
        private static final Map<String, FileFormat> CONSTANTS;

        private FileFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FileFormat fromValue(String value) {
            FileFormat constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FileFormat>();
            for (FileFormat c : FileFormat.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

