/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.dataInsight.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "chartType", "chartDetails", "owner", "dashboard"})
public class CreateDataInsightCustomChart
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name the data insight chart.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="chartType")
    @JsonPropertyDescription(value="Type of chart, used for UI to render the chart")
    private ChartType chartType;
    @JsonProperty(value="chartDetails")
    @NotNull
    private Object chartDetails;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="dashboard")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference dashboard;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateDataInsightCustomChart withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateDataInsightCustomChart withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDataInsightCustomChart withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="chartType")
    public ChartType getChartType() {
        return this.chartType;
    }

    @JsonProperty(value="chartType")
    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    public CreateDataInsightCustomChart withChartType(ChartType chartType) {
        this.chartType = chartType;
        return this;
    }

    @JsonProperty(value="chartDetails")
    public Object getChartDetails() {
        return this.chartDetails;
    }

    @JsonProperty(value="chartDetails")
    public void setChartDetails(Object chartDetails) {
        this.chartDetails = chartDetails;
    }

    public CreateDataInsightCustomChart withChartDetails(Object chartDetails) {
        this.chartDetails = chartDetails;
        return this;
    }

    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateDataInsightCustomChart withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="dashboard")
    public EntityReference getDashboard() {
        return this.dashboard;
    }

    @JsonProperty(value="dashboard")
    public void setDashboard(EntityReference dashboard) {
        this.dashboard = dashboard;
    }

    public CreateDataInsightCustomChart withDashboard(EntityReference dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateDataInsightCustomChart.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("chartType");
        sb.append('=');
        sb.append(this.chartType == null ? "<null>" : this.chartType);
        sb.append(',');
        sb.append("chartDetails");
        sb.append('=');
        sb.append(this.chartDetails == null ? "<null>" : this.chartDetails);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("dashboard");
        sb.append('=');
        sb.append(this.dashboard == null ? "<null>" : this.dashboard);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.chartDetails == null ? 0 : this.chartDetails.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.chartType == null ? 0 : this.chartType.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dashboard == null ? 0 : this.dashboard.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateDataInsightCustomChart)) {
            return false;
        }
        CreateDataInsightCustomChart rhs = (CreateDataInsightCustomChart)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.chartDetails == rhs.chartDetails || this.chartDetails != null && this.chartDetails.equals(rhs.chartDetails)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.chartType == rhs.chartType || this.chartType != null && this.chartType.equals((Object)rhs.chartType)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dashboard == rhs.dashboard || this.dashboard != null && this.dashboard.equals(rhs.dashboard));
    }

    public static enum ChartType {
        LINE_CHART("LineChart"),
        AREA_CHART("AreaChart"),
        BAR_CHART("BarChart"),
        SUMMARY_CARD("SummaryCard");

        private final String value;
        private static final Map<String, ChartType> CONSTANTS;

        private ChartType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ChartType fromValue(String value) {
            ChartType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ChartType>();
            for (ChartType c : ChartType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

