/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.dataInsight.kpi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.dataInsight.kpi.KpiDataInsightChart;
import org.openmetadata.schema.dataInsight.type.KpiTargetType;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owners", "dataInsightChart", "startDate", "endDate", "targetValue", "metricType", "domain"})
public class CreateKpiRequest
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Kpi.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="dataInsightChart")
    @JsonPropertyDescription(value="Fully qualified name of the Chart this kpi refers to")
    @NotNull
    private KpiDataInsightChart dataInsightChart;
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long startDate;
    @JsonProperty(value="endDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long endDate;
    @JsonProperty(value="targetValue")
    @JsonPropertyDescription(value="Metrics from the chart and the target to achieve the result.")
    @NotNull
    private Double targetValue;
    @JsonProperty(value="metricType")
    @JsonPropertyDescription(value="This enum defines the type of key Result")
    @NotNull
    private KpiTargetType metricType;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateKpiRequest withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateKpiRequest withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateKpiRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateKpiRequest withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="dataInsightChart")
    public KpiDataInsightChart getDataInsightChart() {
        return this.dataInsightChart;
    }

    @JsonProperty(value="dataInsightChart")
    public void setDataInsightChart(KpiDataInsightChart dataInsightChart) {
        this.dataInsightChart = dataInsightChart;
    }

    public CreateKpiRequest withDataInsightChart(KpiDataInsightChart dataInsightChart) {
        this.dataInsightChart = dataInsightChart;
        return this;
    }

    @JsonProperty(value="startDate")
    public Long getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public CreateKpiRequest withStartDate(Long startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="endDate")
    public Long getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public CreateKpiRequest withEndDate(Long endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty(value="targetValue")
    public Double getTargetValue() {
        return this.targetValue;
    }

    @JsonProperty(value="targetValue")
    public void setTargetValue(Double targetValue) {
        this.targetValue = targetValue;
    }

    public CreateKpiRequest withTargetValue(Double targetValue) {
        this.targetValue = targetValue;
        return this;
    }

    @JsonProperty(value="metricType")
    public KpiTargetType getMetricType() {
        return this.metricType;
    }

    @JsonProperty(value="metricType")
    public void setMetricType(KpiTargetType metricType) {
        this.metricType = metricType;
    }

    public CreateKpiRequest withMetricType(KpiTargetType metricType) {
        this.metricType = metricType;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateKpiRequest withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateKpiRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("dataInsightChart");
        sb.append('=');
        sb.append(this.dataInsightChart == null ? "<null>" : this.dataInsightChart);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("targetValue");
        sb.append('=');
        sb.append(this.targetValue == null ? "<null>" : this.targetValue);
        sb.append(',');
        sb.append("metricType");
        sb.append('=');
        sb.append(this.metricType == null ? "<null>" : this.metricType);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.metricType == null ? 0 : this.metricType.hashCode());
        result = result * 31 + (this.dataInsightChart == null ? 0 : this.dataInsightChart.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.targetValue == null ? 0 : this.targetValue.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateKpiRequest)) {
            return false;
        }
        CreateKpiRequest rhs = (CreateKpiRequest)other;
        return (this.metricType == rhs.metricType || this.metricType != null && this.metricType.equals((Object)rhs.metricType)) && (this.dataInsightChart == rhs.dataInsightChart || this.dataInsightChart != null && this.dataInsightChart.equals((Object)rhs.dataInsightChart)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.targetValue == rhs.targetValue || this.targetValue != null && this.targetValue.equals(rhs.targetValue)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }
}

