/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.domains;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.type.Style;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"domainType", "name", "fullyQualifiedName", "displayName", "description", "style", "parent", "owners", "experts"})
public class CreateDomain
implements CreateEntity {
    @JsonProperty(value="domainType")
    @JsonPropertyDescription(value="Type of a domain")
    @NotNull
    private DomainType domainType;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Name used for display purposes. Example 'Marketing', 'Payments', etc.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="style")
    @JsonPropertyDescription(value="UI Style is used to associate a color code and/or icon to entity to customize the look of that entity in UI.")
    @Valid
    private Style style;
    @JsonProperty(value="parent")
    @JsonPropertyDescription(value="Fully qualified name of parent domain.")
    private String parent;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="experts")
    @JsonPropertyDescription(value="List of user/login names of users who are experts in this Domain.")
    @Valid
    private List<String> experts = null;

    @JsonProperty(value="domainType")
    public DomainType getDomainType() {
        return this.domainType;
    }

    @JsonProperty(value="domainType")
    public void setDomainType(DomainType domainType) {
        this.domainType = domainType;
    }

    public CreateDomain withDomainType(DomainType domainType) {
        this.domainType = domainType;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateDomain withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public CreateDomain withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateDomain withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDomain withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="style")
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    public void setStyle(Style style) {
        this.style = style;
    }

    public CreateDomain withStyle(Style style) {
        this.style = style;
        return this;
    }

    @JsonProperty(value="parent")
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    public CreateDomain withParent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateDomain withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="experts")
    public List<String> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    public void setExperts(List<String> experts) {
        this.experts = experts;
    }

    public CreateDomain withExperts(List<String> experts) {
        this.experts = experts;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateDomain.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("domainType");
        sb.append('=');
        sb.append(this.domainType == null ? "<null>" : this.domainType);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(this.style == null ? "<null>" : this.style);
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(this.parent == null ? "<null>" : this.parent);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("experts");
        sb.append('=');
        sb.append(this.experts == null ? "<null>" : this.experts);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.parent == null ? 0 : this.parent.hashCode());
        result = result * 31 + (this.domainType == null ? 0 : this.domainType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.style == null ? 0 : this.style.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.experts == null ? 0 : this.experts.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateDomain)) {
            return false;
        }
        CreateDomain rhs = (CreateDomain)other;
        return (this.parent == rhs.parent || this.parent != null && this.parent.equals(rhs.parent)) && (this.domainType == rhs.domainType || this.domainType != null && this.domainType.equals((Object)rhs.domainType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.style == rhs.style || this.style != null && this.style.equals(rhs.style)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.experts == rhs.experts || this.experts != null && this.experts.equals(rhs.experts));
    }

    public static enum DomainType {
        SOURCE_ALIGNED("Source-aligned"),
        CONSUMER_ALIGNED("Consumer-aligned"),
        AGGREGATE("Aggregate");

        private final String value;
        private static final Map<String, DomainType> CONSTANTS;

        private DomainType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DomainType fromValue(String value) {
            DomainType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DomainType>();
            for (DomainType c : DomainType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

