/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.events.AlertFilteringInput;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.events.TriggerConfig;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owners", "enabled", "batchSize", "alertType", "trigger", "resources", "destinations", "provider", "retries", "pollInterval", "input", "domain"})
public class CreateEventSubscription
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display name for this Alert.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is the alert enabled.")
    private Boolean enabled = true;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 10).")
    private Integer batchSize = 10;
    @JsonProperty(value="alertType")
    @JsonPropertyDescription(value="Type of Alerts supported.")
    @NotNull
    private AlertType alertType = AlertType.fromValue("Notification");
    @JsonProperty(value="trigger")
    @JsonPropertyDescription(value="Trigger Configuration for Alerts.")
    @Valid
    private TriggerConfig trigger;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Defines a list of resources that triggers the Event Subscription, Eg All, User, Teams etc.")
    @Valid
    private List<String> resources = new ArrayList<String>();
    @JsonProperty(value="destinations")
    @JsonPropertyDescription(value="Subscription Config.")
    @Valid
    private List<SubscriptionDestination> destinations = new ArrayList<SubscriptionDestination>();
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="Number of times to retry callback on failure. (Default 3).")
    private Integer retries = 3;
    @JsonProperty(value="pollInterval")
    @JsonPropertyDescription(value="Poll Interval in seconds.")
    private Integer pollInterval = 10;
    @JsonProperty(value="input")
    @JsonPropertyDescription(value="Observability of the event subscription.")
    @Valid
    private AlertFilteringInput input;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateEventSubscription withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateEventSubscription withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateEventSubscription withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateEventSubscription withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CreateEventSubscription withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public CreateEventSubscription withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="alertType")
    public AlertType getAlertType() {
        return this.alertType;
    }

    @JsonProperty(value="alertType")
    public void setAlertType(AlertType alertType) {
        this.alertType = alertType;
    }

    public CreateEventSubscription withAlertType(AlertType alertType) {
        this.alertType = alertType;
        return this;
    }

    @JsonProperty(value="trigger")
    public TriggerConfig getTrigger() {
        return this.trigger;
    }

    @JsonProperty(value="trigger")
    public void setTrigger(TriggerConfig trigger) {
        this.trigger = trigger;
    }

    public CreateEventSubscription withTrigger(TriggerConfig trigger) {
        this.trigger = trigger;
        return this;
    }

    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public CreateEventSubscription withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    @JsonProperty(value="destinations")
    public List<SubscriptionDestination> getDestinations() {
        return this.destinations;
    }

    @JsonProperty(value="destinations")
    public void setDestinations(List<SubscriptionDestination> destinations) {
        this.destinations = destinations;
    }

    public CreateEventSubscription withDestinations(List<SubscriptionDestination> destinations) {
        this.destinations = destinations;
        return this;
    }

    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public CreateEventSubscription withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public CreateEventSubscription withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="pollInterval")
    public Integer getPollInterval() {
        return this.pollInterval;
    }

    @JsonProperty(value="pollInterval")
    public void setPollInterval(Integer pollInterval) {
        this.pollInterval = pollInterval;
    }

    public CreateEventSubscription withPollInterval(Integer pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    @JsonProperty(value="input")
    public AlertFilteringInput getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(AlertFilteringInput input) {
        this.input = input;
    }

    public CreateEventSubscription withInput(AlertFilteringInput input) {
        this.input = input;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateEventSubscription withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateEventSubscription.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("alertType");
        sb.append('=');
        sb.append(this.alertType == null ? "<null>" : this.alertType);
        sb.append(',');
        sb.append("trigger");
        sb.append('=');
        sb.append(this.trigger == null ? "<null>" : this.trigger);
        sb.append(',');
        sb.append("resources");
        sb.append('=');
        sb.append(this.resources == null ? "<null>" : this.resources);
        sb.append(',');
        sb.append("destinations");
        sb.append('=');
        sb.append(this.destinations == null ? "<null>" : this.destinations);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("retries");
        sb.append('=');
        sb.append(this.retries == null ? "<null>" : this.retries);
        sb.append(',');
        sb.append("pollInterval");
        sb.append('=');
        sb.append(this.pollInterval == null ? "<null>" : this.pollInterval);
        sb.append(',');
        sb.append("input");
        sb.append('=');
        sb.append(this.input == null ? "<null>" : this.input);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.alertType == null ? 0 : this.alertType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.destinations == null ? 0 : this.destinations.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.resources == null ? 0 : this.resources.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.trigger == null ? 0 : this.trigger.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.retries == null ? 0 : this.retries.hashCode());
        result = result * 31 + (this.input == null ? 0 : this.input.hashCode());
        result = result * 31 + (this.pollInterval == null ? 0 : this.pollInterval.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateEventSubscription)) {
            return false;
        }
        CreateEventSubscription rhs = (CreateEventSubscription)other;
        return (this.alertType == rhs.alertType || this.alertType != null && this.alertType.equals((Object)rhs.alertType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.destinations == rhs.destinations || this.destinations != null && this.destinations.equals(rhs.destinations)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.resources == rhs.resources || this.resources != null && this.resources.equals(rhs.resources)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.trigger == rhs.trigger || this.trigger != null && this.trigger.equals(rhs.trigger)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.retries == rhs.retries || this.retries != null && this.retries.equals(rhs.retries)) && (this.input == rhs.input || this.input != null && this.input.equals(rhs.input)) && (this.pollInterval == rhs.pollInterval || this.pollInterval != null && this.pollInterval.equals(rhs.pollInterval)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize));
    }

    public static enum AlertType {
        NOTIFICATION("Notification"),
        OBSERVABILITY("Observability"),
        ACTIVITY_FEED("ActivityFeed");

        private final String value;
        private static final Map<String, AlertType> CONSTANTS;

        private AlertType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AlertType fromValue(String value) {
            AlertType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AlertType>();
            for (AlertType c : AlertType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

