/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.feed;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"description", "tagLabels", "type", "entityLink"})
public class CreateSuggestion {
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Message in Markdown format. See markdown support for more details.")
    private String description;
    @JsonProperty(value="tagLabels")
    @JsonPropertyDescription(value="Tags or Glossary Terms.")
    @Valid
    private List<TagLabel> tagLabels = null;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of a Suggestion.")
    private SuggestionType type;
    @JsonProperty(value="entityLink")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$")
    private @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$") String entityLink;

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateSuggestion withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="tagLabels")
    public List<TagLabel> getTagLabels() {
        return this.tagLabels;
    }

    @JsonProperty(value="tagLabels")
    public void setTagLabels(List<TagLabel> tagLabels) {
        this.tagLabels = tagLabels;
    }

    public CreateSuggestion withTagLabels(List<TagLabel> tagLabels) {
        this.tagLabels = tagLabels;
        return this;
    }

    @JsonProperty(value="type")
    public SuggestionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SuggestionType type) {
        this.type = type;
    }

    public CreateSuggestion withType(SuggestionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="entityLink")
    public String getEntityLink() {
        return this.entityLink;
    }

    @JsonProperty(value="entityLink")
    public void setEntityLink(String entityLink) {
        this.entityLink = entityLink;
    }

    public CreateSuggestion withEntityLink(String entityLink) {
        this.entityLink = entityLink;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateSuggestion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tagLabels");
        sb.append('=');
        sb.append(this.tagLabels == null ? "<null>" : this.tagLabels);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("entityLink");
        sb.append('=');
        sb.append(this.entityLink == null ? "<null>" : this.entityLink);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.tagLabels == null ? 0 : this.tagLabels.hashCode());
        result = result * 31 + (this.entityLink == null ? 0 : this.entityLink.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateSuggestion)) {
            return false;
        }
        CreateSuggestion rhs = (CreateSuggestion)other;
        return (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.tagLabels == rhs.tagLabels || this.tagLabels != null && this.tagLabels.equals(rhs.tagLabels)) && (this.entityLink == rhs.entityLink || this.entityLink != null && this.entityLink.equals(rhs.entityLink)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }
}

