/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.feed;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.tests.type.TestCaseFailureReasonType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"newValue", "testCaseFailureReason", "testCaseFQN"})
public class ResolveTask {
    @JsonProperty(value="newValue")
    @JsonPropertyDescription(value="The new value object that needs to be updated to resolve the task.")
    @NotNull
    private String newValue;
    @JsonProperty(value="testCaseFailureReason")
    @JsonPropertyDescription(value="Reason of Test Case initial failure.")
    private TestCaseFailureReasonType testCaseFailureReason;
    @JsonProperty(value="testCaseFQN")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String testCaseFQN;

    @JsonProperty(value="newValue")
    public String getNewValue() {
        return this.newValue;
    }

    @JsonProperty(value="newValue")
    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public ResolveTask withNewValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    @JsonProperty(value="testCaseFailureReason")
    public TestCaseFailureReasonType getTestCaseFailureReason() {
        return this.testCaseFailureReason;
    }

    @JsonProperty(value="testCaseFailureReason")
    public void setTestCaseFailureReason(TestCaseFailureReasonType testCaseFailureReason) {
        this.testCaseFailureReason = testCaseFailureReason;
    }

    public ResolveTask withTestCaseFailureReason(TestCaseFailureReasonType testCaseFailureReason) {
        this.testCaseFailureReason = testCaseFailureReason;
        return this;
    }

    @JsonProperty(value="testCaseFQN")
    public String getTestCaseFQN() {
        return this.testCaseFQN;
    }

    @JsonProperty(value="testCaseFQN")
    public void setTestCaseFQN(String testCaseFQN) {
        this.testCaseFQN = testCaseFQN;
    }

    public ResolveTask withTestCaseFQN(String testCaseFQN) {
        this.testCaseFQN = testCaseFQN;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResolveTask.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("newValue");
        sb.append('=');
        sb.append(this.newValue == null ? "<null>" : this.newValue);
        sb.append(',');
        sb.append("testCaseFailureReason");
        sb.append('=');
        sb.append(this.testCaseFailureReason == null ? "<null>" : this.testCaseFailureReason);
        sb.append(',');
        sb.append("testCaseFQN");
        sb.append('=');
        sb.append(this.testCaseFQN == null ? "<null>" : this.testCaseFQN);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.newValue == null ? 0 : this.newValue.hashCode());
        result = result * 31 + (this.testCaseFQN == null ? 0 : this.testCaseFQN.hashCode());
        result = result * 31 + (this.testCaseFailureReason == null ? 0 : this.testCaseFailureReason.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResolveTask)) {
            return false;
        }
        ResolveTask rhs = (ResolveTask)other;
        return (this.newValue == rhs.newValue || this.newValue != null && this.newValue.equals(rhs.newValue)) && (this.testCaseFQN == rhs.testCaseFQN || this.testCaseFQN != null && this.testCaseFQN.equals(rhs.testCaseFQN)) && (this.testCaseFailureReason == rhs.testCaseFailureReason || this.testCaseFailureReason != null && this.testCaseFailureReason.equals((Object)rhs.testCaseFailureReason));
    }
}

