/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.feed;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conversationCount", "openTaskCount", "closedTaskCount", "totalTaskCount", "mentionCount", "entityLink"})
public class ThreadCount {
    @JsonProperty(value="conversationCount")
    @JsonPropertyDescription(value="Total count of all the threads of type Conversation.")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer conversationCount;
    @JsonProperty(value="openTaskCount")
    @JsonPropertyDescription(value="Total count of all the open tasks.")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer openTaskCount;
    @JsonProperty(value="closedTaskCount")
    @JsonPropertyDescription(value="Total count of all the tasks.")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer closedTaskCount;
    @JsonProperty(value="totalTaskCount")
    @JsonPropertyDescription(value="Total count of all the tasks.")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer totalTaskCount;
    @JsonProperty(value="mentionCount")
    @JsonPropertyDescription(value="Total count of all the mentions of a user.")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer mentionCount;
    @JsonProperty(value="entityLink")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$")
    private @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$") String entityLink;

    @JsonProperty(value="conversationCount")
    public Integer getConversationCount() {
        return this.conversationCount;
    }

    @JsonProperty(value="conversationCount")
    public void setConversationCount(Integer conversationCount) {
        this.conversationCount = conversationCount;
    }

    public ThreadCount withConversationCount(Integer conversationCount) {
        this.conversationCount = conversationCount;
        return this;
    }

    @JsonProperty(value="openTaskCount")
    public Integer getOpenTaskCount() {
        return this.openTaskCount;
    }

    @JsonProperty(value="openTaskCount")
    public void setOpenTaskCount(Integer openTaskCount) {
        this.openTaskCount = openTaskCount;
    }

    public ThreadCount withOpenTaskCount(Integer openTaskCount) {
        this.openTaskCount = openTaskCount;
        return this;
    }

    @JsonProperty(value="closedTaskCount")
    public Integer getClosedTaskCount() {
        return this.closedTaskCount;
    }

    @JsonProperty(value="closedTaskCount")
    public void setClosedTaskCount(Integer closedTaskCount) {
        this.closedTaskCount = closedTaskCount;
    }

    public ThreadCount withClosedTaskCount(Integer closedTaskCount) {
        this.closedTaskCount = closedTaskCount;
        return this;
    }

    @JsonProperty(value="totalTaskCount")
    public Integer getTotalTaskCount() {
        return this.totalTaskCount;
    }

    @JsonProperty(value="totalTaskCount")
    public void setTotalTaskCount(Integer totalTaskCount) {
        this.totalTaskCount = totalTaskCount;
    }

    public ThreadCount withTotalTaskCount(Integer totalTaskCount) {
        this.totalTaskCount = totalTaskCount;
        return this;
    }

    @JsonProperty(value="mentionCount")
    public Integer getMentionCount() {
        return this.mentionCount;
    }

    @JsonProperty(value="mentionCount")
    public void setMentionCount(Integer mentionCount) {
        this.mentionCount = mentionCount;
    }

    public ThreadCount withMentionCount(Integer mentionCount) {
        this.mentionCount = mentionCount;
        return this;
    }

    @JsonProperty(value="entityLink")
    public String getEntityLink() {
        return this.entityLink;
    }

    @JsonProperty(value="entityLink")
    public void setEntityLink(String entityLink) {
        this.entityLink = entityLink;
    }

    public ThreadCount withEntityLink(String entityLink) {
        this.entityLink = entityLink;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ThreadCount.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("conversationCount");
        sb.append('=');
        sb.append(this.conversationCount == null ? "<null>" : this.conversationCount);
        sb.append(',');
        sb.append("openTaskCount");
        sb.append('=');
        sb.append(this.openTaskCount == null ? "<null>" : this.openTaskCount);
        sb.append(',');
        sb.append("closedTaskCount");
        sb.append('=');
        sb.append(this.closedTaskCount == null ? "<null>" : this.closedTaskCount);
        sb.append(',');
        sb.append("totalTaskCount");
        sb.append('=');
        sb.append(this.totalTaskCount == null ? "<null>" : this.totalTaskCount);
        sb.append(',');
        sb.append("mentionCount");
        sb.append('=');
        sb.append(this.mentionCount == null ? "<null>" : this.mentionCount);
        sb.append(',');
        sb.append("entityLink");
        sb.append('=');
        sb.append(this.entityLink == null ? "<null>" : this.entityLink);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.mentionCount == null ? 0 : this.mentionCount.hashCode());
        result = result * 31 + (this.conversationCount == null ? 0 : this.conversationCount.hashCode());
        result = result * 31 + (this.totalTaskCount == null ? 0 : this.totalTaskCount.hashCode());
        result = result * 31 + (this.entityLink == null ? 0 : this.entityLink.hashCode());
        result = result * 31 + (this.closedTaskCount == null ? 0 : this.closedTaskCount.hashCode());
        result = result * 31 + (this.openTaskCount == null ? 0 : this.openTaskCount.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ThreadCount)) {
            return false;
        }
        ThreadCount rhs = (ThreadCount)other;
        return (this.mentionCount == rhs.mentionCount || this.mentionCount != null && this.mentionCount.equals(rhs.mentionCount)) && (this.conversationCount == rhs.conversationCount || this.conversationCount != null && this.conversationCount.equals(rhs.conversationCount)) && (this.totalTaskCount == rhs.totalTaskCount || this.totalTaskCount != null && this.totalTaskCount.equals(rhs.totalTaskCount)) && (this.entityLink == rhs.entityLink || this.entityLink != null && this.entityLink.equals(rhs.entityLink)) && (this.closedTaskCount == rhs.closedTaskCount || this.closedTaskCount != null && this.closedTaskCount.equals(rhs.closedTaskCount)) && (this.openTaskCount == rhs.openTaskCount || this.openTaskCount != null && this.openTaskCount.equals(rhs.openTaskCount));
    }
}

