/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"topics", "acks", "retries", "lingerMS", "bufferMemory", "keySerializer", "valueSerializer", "securityProtocol", "SSLProtocol", "SSLTrustStoreLocation", "SSLTrustStorePassword", "SSLKeystoreLocation", "SSLKeystorePassword", "SSLKeyPassword"})
public class KafkaEventConfiguration {
    @JsonProperty(value="topics")
    @JsonPropertyDescription(value="Topics of Kafka Producer")
    @Valid
    @NotNull
    private List<String> topics = new ArrayList<String>();
    @JsonProperty(value="acks")
    @JsonPropertyDescription(value="Acknowledgment")
    private String acks = "all";
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="No. of retries")
    private Integer retries = 3;
    @JsonProperty(value="lingerMS")
    @JsonPropertyDescription(value="Artificial Delay in milliseconds")
    private Integer lingerMS = 1;
    @JsonProperty(value="bufferMemory")
    @JsonPropertyDescription(value="Buffer Memory")
    private Integer bufferMemory = 0x2000000;
    @JsonProperty(value="keySerializer")
    @JsonPropertyDescription(value="Serializer class for key")
    private String keySerializer = "org.apache.kafka.common.serialization.StringSerializer";
    @JsonProperty(value="valueSerializer")
    @JsonPropertyDescription(value="Serializer class for value")
    private String valueSerializer = "org.apache.kafka.common.serialization.StringSerializer";
    @JsonProperty(value="securityProtocol")
    @JsonPropertyDescription(value="Kafka security protocol config")
    private SecurityProtocol securityProtocol = SecurityProtocol.fromValue("PLAINTEXT");
    @JsonProperty(value="SSLProtocol")
    @JsonPropertyDescription(value="Kafka SSL protocol config")
    private String sSLProtocol = "TLSv1.2";
    @JsonProperty(value="SSLTrustStoreLocation")
    @JsonPropertyDescription(value="Kafka SSL truststore location")
    private String sSLTrustStoreLocation;
    @JsonProperty(value="SSLTrustStorePassword")
    @JsonPropertyDescription(value="Kafka SSL truststore password")
    private String sSLTrustStorePassword;
    @JsonProperty(value="SSLKeystoreLocation")
    @JsonPropertyDescription(value="Kafka SSL keystore location")
    private String sSLKeystoreLocation;
    @JsonProperty(value="SSLKeystorePassword")
    @JsonPropertyDescription(value="Kafka SSL keystore password")
    private String sSLKeystorePassword;
    @JsonProperty(value="SSLKeyPassword")
    @JsonPropertyDescription(value="Kafka SSL key password")
    private String sSLKeyPassword;

    @JsonProperty(value="topics")
    public List<String> getTopics() {
        return this.topics;
    }

    @JsonProperty(value="topics")
    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public KafkaEventConfiguration withTopics(List<String> topics) {
        this.topics = topics;
        return this;
    }

    @JsonProperty(value="acks")
    public String getAcks() {
        return this.acks;
    }

    @JsonProperty(value="acks")
    public void setAcks(String acks) {
        this.acks = acks;
    }

    public KafkaEventConfiguration withAcks(String acks) {
        this.acks = acks;
        return this;
    }

    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public KafkaEventConfiguration withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="lingerMS")
    public Integer getLingerMS() {
        return this.lingerMS;
    }

    @JsonProperty(value="lingerMS")
    public void setLingerMS(Integer lingerMS) {
        this.lingerMS = lingerMS;
    }

    public KafkaEventConfiguration withLingerMS(Integer lingerMS) {
        this.lingerMS = lingerMS;
        return this;
    }

    @JsonProperty(value="bufferMemory")
    public Integer getBufferMemory() {
        return this.bufferMemory;
    }

    @JsonProperty(value="bufferMemory")
    public void setBufferMemory(Integer bufferMemory) {
        this.bufferMemory = bufferMemory;
    }

    public KafkaEventConfiguration withBufferMemory(Integer bufferMemory) {
        this.bufferMemory = bufferMemory;
        return this;
    }

    @JsonProperty(value="keySerializer")
    public String getKeySerializer() {
        return this.keySerializer;
    }

    @JsonProperty(value="keySerializer")
    public void setKeySerializer(String keySerializer) {
        this.keySerializer = keySerializer;
    }

    public KafkaEventConfiguration withKeySerializer(String keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    @JsonProperty(value="valueSerializer")
    public String getValueSerializer() {
        return this.valueSerializer;
    }

    @JsonProperty(value="valueSerializer")
    public void setValueSerializer(String valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public KafkaEventConfiguration withValueSerializer(String valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    @JsonProperty(value="securityProtocol")
    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    @JsonProperty(value="securityProtocol")
    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public KafkaEventConfiguration withSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    @JsonProperty(value="SSLProtocol")
    public String getSSLProtocol() {
        return this.sSLProtocol;
    }

    @JsonProperty(value="SSLProtocol")
    public void setSSLProtocol(String sSLProtocol) {
        this.sSLProtocol = sSLProtocol;
    }

    public KafkaEventConfiguration withSSLProtocol(String sSLProtocol) {
        this.sSLProtocol = sSLProtocol;
        return this;
    }

    @JsonProperty(value="SSLTrustStoreLocation")
    public String getSSLTrustStoreLocation() {
        return this.sSLTrustStoreLocation;
    }

    @JsonProperty(value="SSLTrustStoreLocation")
    public void setSSLTrustStoreLocation(String sSLTrustStoreLocation) {
        this.sSLTrustStoreLocation = sSLTrustStoreLocation;
    }

    public KafkaEventConfiguration withSSLTrustStoreLocation(String sSLTrustStoreLocation) {
        this.sSLTrustStoreLocation = sSLTrustStoreLocation;
        return this;
    }

    @JsonProperty(value="SSLTrustStorePassword")
    public String getSSLTrustStorePassword() {
        return this.sSLTrustStorePassword;
    }

    @JsonProperty(value="SSLTrustStorePassword")
    public void setSSLTrustStorePassword(String sSLTrustStorePassword) {
        this.sSLTrustStorePassword = sSLTrustStorePassword;
    }

    public KafkaEventConfiguration withSSLTrustStorePassword(String sSLTrustStorePassword) {
        this.sSLTrustStorePassword = sSLTrustStorePassword;
        return this;
    }

    @JsonProperty(value="SSLKeystoreLocation")
    public String getSSLKeystoreLocation() {
        return this.sSLKeystoreLocation;
    }

    @JsonProperty(value="SSLKeystoreLocation")
    public void setSSLKeystoreLocation(String sSLKeystoreLocation) {
        this.sSLKeystoreLocation = sSLKeystoreLocation;
    }

    public KafkaEventConfiguration withSSLKeystoreLocation(String sSLKeystoreLocation) {
        this.sSLKeystoreLocation = sSLKeystoreLocation;
        return this;
    }

    @JsonProperty(value="SSLKeystorePassword")
    public String getSSLKeystorePassword() {
        return this.sSLKeystorePassword;
    }

    @JsonProperty(value="SSLKeystorePassword")
    public void setSSLKeystorePassword(String sSLKeystorePassword) {
        this.sSLKeystorePassword = sSLKeystorePassword;
    }

    public KafkaEventConfiguration withSSLKeystorePassword(String sSLKeystorePassword) {
        this.sSLKeystorePassword = sSLKeystorePassword;
        return this;
    }

    @JsonProperty(value="SSLKeyPassword")
    public String getSSLKeyPassword() {
        return this.sSLKeyPassword;
    }

    @JsonProperty(value="SSLKeyPassword")
    public void setSSLKeyPassword(String sSLKeyPassword) {
        this.sSLKeyPassword = sSLKeyPassword;
    }

    public KafkaEventConfiguration withSSLKeyPassword(String sSLKeyPassword) {
        this.sSLKeyPassword = sSLKeyPassword;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KafkaEventConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("topics");
        sb.append('=');
        sb.append(this.topics == null ? "<null>" : this.topics);
        sb.append(',');
        sb.append("acks");
        sb.append('=');
        sb.append(this.acks == null ? "<null>" : this.acks);
        sb.append(',');
        sb.append("retries");
        sb.append('=');
        sb.append(this.retries == null ? "<null>" : this.retries);
        sb.append(',');
        sb.append("lingerMS");
        sb.append('=');
        sb.append(this.lingerMS == null ? "<null>" : this.lingerMS);
        sb.append(',');
        sb.append("bufferMemory");
        sb.append('=');
        sb.append(this.bufferMemory == null ? "<null>" : this.bufferMemory);
        sb.append(',');
        sb.append("keySerializer");
        sb.append('=');
        sb.append(this.keySerializer == null ? "<null>" : this.keySerializer);
        sb.append(',');
        sb.append("valueSerializer");
        sb.append('=');
        sb.append(this.valueSerializer == null ? "<null>" : this.valueSerializer);
        sb.append(',');
        sb.append("securityProtocol");
        sb.append('=');
        sb.append(this.securityProtocol == null ? "<null>" : this.securityProtocol);
        sb.append(',');
        sb.append("sSLProtocol");
        sb.append('=');
        sb.append(this.sSLProtocol == null ? "<null>" : this.sSLProtocol);
        sb.append(',');
        sb.append("sSLTrustStoreLocation");
        sb.append('=');
        sb.append(this.sSLTrustStoreLocation == null ? "<null>" : this.sSLTrustStoreLocation);
        sb.append(',');
        sb.append("sSLTrustStorePassword");
        sb.append('=');
        sb.append(this.sSLTrustStorePassword == null ? "<null>" : this.sSLTrustStorePassword);
        sb.append(',');
        sb.append("sSLKeystoreLocation");
        sb.append('=');
        sb.append(this.sSLKeystoreLocation == null ? "<null>" : this.sSLKeystoreLocation);
        sb.append(',');
        sb.append("sSLKeystorePassword");
        sb.append('=');
        sb.append(this.sSLKeystorePassword == null ? "<null>" : this.sSLKeystorePassword);
        sb.append(',');
        sb.append("sSLKeyPassword");
        sb.append('=');
        sb.append(this.sSLKeyPassword == null ? "<null>" : this.sSLKeyPassword);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sSLKeystoreLocation == null ? 0 : this.sSLKeystoreLocation.hashCode());
        result = result * 31 + (this.sSLProtocol == null ? 0 : this.sSLProtocol.hashCode());
        result = result * 31 + (this.topics == null ? 0 : this.topics.hashCode());
        result = result * 31 + (this.acks == null ? 0 : this.acks.hashCode());
        result = result * 31 + (this.valueSerializer == null ? 0 : this.valueSerializer.hashCode());
        result = result * 31 + (this.sSLTrustStoreLocation == null ? 0 : this.sSLTrustStoreLocation.hashCode());
        result = result * 31 + (this.sSLKeystorePassword == null ? 0 : this.sSLKeystorePassword.hashCode());
        result = result * 31 + (this.sSLTrustStorePassword == null ? 0 : this.sSLTrustStorePassword.hashCode());
        result = result * 31 + (this.keySerializer == null ? 0 : this.keySerializer.hashCode());
        result = result * 31 + (this.retries == null ? 0 : this.retries.hashCode());
        result = result * 31 + (this.bufferMemory == null ? 0 : this.bufferMemory.hashCode());
        result = result * 31 + (this.lingerMS == null ? 0 : this.lingerMS.hashCode());
        result = result * 31 + (this.securityProtocol == null ? 0 : this.securityProtocol.hashCode());
        result = result * 31 + (this.sSLKeyPassword == null ? 0 : this.sSLKeyPassword.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KafkaEventConfiguration)) {
            return false;
        }
        KafkaEventConfiguration rhs = (KafkaEventConfiguration)other;
        return (this.sSLKeystoreLocation == rhs.sSLKeystoreLocation || this.sSLKeystoreLocation != null && this.sSLKeystoreLocation.equals(rhs.sSLKeystoreLocation)) && (this.sSLProtocol == rhs.sSLProtocol || this.sSLProtocol != null && this.sSLProtocol.equals(rhs.sSLProtocol)) && (this.topics == rhs.topics || this.topics != null && this.topics.equals(rhs.topics)) && (this.acks == rhs.acks || this.acks != null && this.acks.equals(rhs.acks)) && (this.valueSerializer == rhs.valueSerializer || this.valueSerializer != null && this.valueSerializer.equals(rhs.valueSerializer)) && (this.sSLTrustStoreLocation == rhs.sSLTrustStoreLocation || this.sSLTrustStoreLocation != null && this.sSLTrustStoreLocation.equals(rhs.sSLTrustStoreLocation)) && (this.sSLKeystorePassword == rhs.sSLKeystorePassword || this.sSLKeystorePassword != null && this.sSLKeystorePassword.equals(rhs.sSLKeystorePassword)) && (this.sSLTrustStorePassword == rhs.sSLTrustStorePassword || this.sSLTrustStorePassword != null && this.sSLTrustStorePassword.equals(rhs.sSLTrustStorePassword)) && (this.keySerializer == rhs.keySerializer || this.keySerializer != null && this.keySerializer.equals(rhs.keySerializer)) && (this.retries == rhs.retries || this.retries != null && this.retries.equals(rhs.retries)) && (this.bufferMemory == rhs.bufferMemory || this.bufferMemory != null && this.bufferMemory.equals(rhs.bufferMemory)) && (this.lingerMS == rhs.lingerMS || this.lingerMS != null && this.lingerMS.equals(rhs.lingerMS)) && (this.securityProtocol == rhs.securityProtocol || this.securityProtocol != null && this.securityProtocol.equals((Object)rhs.securityProtocol)) && (this.sSLKeyPassword == rhs.sSLKeyPassword || this.sSLKeyPassword != null && this.sSLKeyPassword.equals(rhs.sSLKeyPassword));
    }

    public static enum SecurityProtocol {
        PLAINTEXT("PLAINTEXT"),
        SSL("SSL");

        private final String value;
        private static final Map<String, SecurityProtocol> CONSTANTS;

        private SecurityProtocol(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SecurityProtocol fromValue(String value) {
            SecurityProtocol constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SecurityProtocol>();
            for (SecurityProtocol c : SecurityProtocol.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

