/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.lineage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum LineageLayer {
    ENTITY_LINEAGE("EntityLineage"),
    COLUMN_LEVEL_LINEAGE("ColumnLevelLineage"),
    DATA_OBSERVABILITY("DataObservability");

    private final String value;
    private static final Map<String, LineageLayer> CONSTANTS;

    private LineageLayer(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static LineageLayer fromValue(String value) {
        LineageLayer constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, LineageLayer>();
        for (LineageLayer c : LineageLayer.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

