/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.lineage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.api.lineage.LineageLayer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"upstreamDepth", "downstreamDepth", "lineageLayer"})
public class LineageSettings {
    @JsonProperty(value="upstreamDepth")
    @JsonPropertyDescription(value="Upstream Depth for Lineage.")
    @DecimalMin(value="1")
    @DecimalMax(value="5")
    @NotNull
    private @DecimalMin(value="1") @DecimalMax(value="5") @NotNull Integer upstreamDepth = 2;
    @JsonProperty(value="downstreamDepth")
    @JsonPropertyDescription(value="DownStream Depth for Lineage.")
    @DecimalMin(value="1")
    @DecimalMax(value="5")
    @NotNull
    private @DecimalMin(value="1") @DecimalMax(value="5") @NotNull Integer downstreamDepth = 2;
    @JsonProperty(value="lineageLayer")
    @JsonPropertyDescription(value="Lineage Layers")
    @NotNull
    private LineageLayer lineageLayer = LineageLayer.fromValue("EntityLineage");

    @JsonProperty(value="upstreamDepth")
    public Integer getUpstreamDepth() {
        return this.upstreamDepth;
    }

    @JsonProperty(value="upstreamDepth")
    public void setUpstreamDepth(Integer upstreamDepth) {
        this.upstreamDepth = upstreamDepth;
    }

    public LineageSettings withUpstreamDepth(Integer upstreamDepth) {
        this.upstreamDepth = upstreamDepth;
        return this;
    }

    @JsonProperty(value="downstreamDepth")
    public Integer getDownstreamDepth() {
        return this.downstreamDepth;
    }

    @JsonProperty(value="downstreamDepth")
    public void setDownstreamDepth(Integer downstreamDepth) {
        this.downstreamDepth = downstreamDepth;
    }

    public LineageSettings withDownstreamDepth(Integer downstreamDepth) {
        this.downstreamDepth = downstreamDepth;
        return this;
    }

    @JsonProperty(value="lineageLayer")
    public LineageLayer getLineageLayer() {
        return this.lineageLayer;
    }

    @JsonProperty(value="lineageLayer")
    public void setLineageLayer(LineageLayer lineageLayer) {
        this.lineageLayer = lineageLayer;
    }

    public LineageSettings withLineageLayer(LineageLayer lineageLayer) {
        this.lineageLayer = lineageLayer;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LineageSettings.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("upstreamDepth");
        sb.append('=');
        sb.append(this.upstreamDepth == null ? "<null>" : this.upstreamDepth);
        sb.append(',');
        sb.append("downstreamDepth");
        sb.append('=');
        sb.append(this.downstreamDepth == null ? "<null>" : this.downstreamDepth);
        sb.append(',');
        sb.append("lineageLayer");
        sb.append('=');
        sb.append(this.lineageLayer == null ? "<null>" : this.lineageLayer);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.upstreamDepth == null ? 0 : this.upstreamDepth.hashCode());
        result = result * 31 + (this.lineageLayer == null ? 0 : this.lineageLayer.hashCode());
        result = result * 31 + (this.downstreamDepth == null ? 0 : this.downstreamDepth.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LineageSettings)) {
            return false;
        }
        LineageSettings rhs = (LineageSettings)other;
        return (this.upstreamDepth == rhs.upstreamDepth || this.upstreamDepth != null && this.upstreamDepth.equals(rhs.upstreamDepth)) && (this.lineageLayer == rhs.lineageLayer || this.lineageLayer != null && this.lineageLayer.equals((Object)rhs.lineageLayer)) && (this.downstreamDepth == rhs.downstreamDepth || this.downstreamDepth != null && this.downstreamDepth.equals(rhs.downstreamDepth));
    }
}

