/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.catalog.security.client.SamlSSOClientConfig;
import org.openmetadata.schema.api.security.ClientType;
import org.openmetadata.schema.api.security.ResponseType;
import org.openmetadata.schema.auth.LdapConfiguration;
import org.openmetadata.schema.security.client.OidcClientConfig;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clientType", "provider", "responseType", "providerName", "publicKeyUrls", "authority", "clientId", "callbackUrl", "jwtPrincipalClaims", "jwtPrincipalClaimsMapping", "enableSelfSignup", "ldapConfiguration", "samlConfiguration", "oidcConfiguration"})
public class AuthenticationConfiguration {
    @JsonProperty(value="clientType")
    @JsonPropertyDescription(value="Client Type")
    private ClientType clientType = ClientType.fromValue("public");
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="OpenMetadata Server Authentication Provider. Make sure configure same auth providers as the one configured on OpenMetadata server.")
    @NotNull
    private AuthProvider provider = AuthProvider.fromValue("basic");
    @JsonProperty(value="responseType")
    @JsonPropertyDescription(value="Response Type")
    private ResponseType responseType = ResponseType.fromValue("id_token");
    @JsonProperty(value="providerName")
    @JsonPropertyDescription(value="Custom OIDC Authentication Provider Name")
    @NotNull
    private String providerName;
    @JsonProperty(value="publicKeyUrls")
    @JsonPropertyDescription(value="List of Public Key URLs")
    @Valid
    @NotNull
    private List<String> publicKeyUrls = new ArrayList<String>();
    @JsonProperty(value="authority")
    @JsonPropertyDescription(value="Authentication Authority")
    @NotNull
    private String authority;
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Client ID")
    @NotNull
    private String clientId;
    @JsonProperty(value="callbackUrl")
    @JsonPropertyDescription(value="Callback URL")
    @NotNull
    private String callbackUrl;
    @JsonProperty(value="jwtPrincipalClaims")
    @JsonPropertyDescription(value="Jwt Principal Claim")
    @Valid
    @NotNull
    private List<String> jwtPrincipalClaims = new ArrayList<String>();
    @JsonProperty(value="jwtPrincipalClaimsMapping")
    @JsonPropertyDescription(value="Jwt Principal Claim Mapping")
    @Valid
    private List<String> jwtPrincipalClaimsMapping = new ArrayList<String>();
    @JsonProperty(value="enableSelfSignup")
    @JsonPropertyDescription(value="Enable Self Sign Up")
    private Boolean enableSelfSignup = false;
    @JsonProperty(value="ldapConfiguration")
    @JsonPropertyDescription(value="LDAP Configuration")
    @Valid
    private LdapConfiguration ldapConfiguration;
    @JsonProperty(value="samlConfiguration")
    @JsonPropertyDescription(value="SAML SSO client security configs.")
    @Valid
    private SamlSSOClientConfig samlConfiguration;
    @JsonProperty(value="oidcConfiguration")
    @JsonPropertyDescription(value="Oidc client security configs.")
    @Valid
    private OidcClientConfig oidcConfiguration;

    @JsonProperty(value="clientType")
    public ClientType getClientType() {
        return this.clientType;
    }

    @JsonProperty(value="clientType")
    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public AuthenticationConfiguration withClientType(ClientType clientType) {
        this.clientType = clientType;
        return this;
    }

    @JsonProperty(value="provider")
    public AuthProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(AuthProvider provider) {
        this.provider = provider;
    }

    public AuthenticationConfiguration withProvider(AuthProvider provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="responseType")
    public ResponseType getResponseType() {
        return this.responseType;
    }

    @JsonProperty(value="responseType")
    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    public AuthenticationConfiguration withResponseType(ResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty(value="providerName")
    public String getProviderName() {
        return this.providerName;
    }

    @JsonProperty(value="providerName")
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public AuthenticationConfiguration withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    @JsonProperty(value="publicKeyUrls")
    public List<String> getPublicKeyUrls() {
        return this.publicKeyUrls;
    }

    @JsonProperty(value="publicKeyUrls")
    public void setPublicKeyUrls(List<String> publicKeyUrls) {
        this.publicKeyUrls = publicKeyUrls;
    }

    public AuthenticationConfiguration withPublicKeyUrls(List<String> publicKeyUrls) {
        this.publicKeyUrls = publicKeyUrls;
        return this;
    }

    @JsonProperty(value="authority")
    public String getAuthority() {
        return this.authority;
    }

    @JsonProperty(value="authority")
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public AuthenticationConfiguration withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AuthenticationConfiguration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="callbackUrl")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callbackUrl")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public AuthenticationConfiguration withCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @JsonProperty(value="jwtPrincipalClaims")
    public List<String> getJwtPrincipalClaims() {
        return this.jwtPrincipalClaims;
    }

    @JsonProperty(value="jwtPrincipalClaims")
    public void setJwtPrincipalClaims(List<String> jwtPrincipalClaims) {
        this.jwtPrincipalClaims = jwtPrincipalClaims;
    }

    public AuthenticationConfiguration withJwtPrincipalClaims(List<String> jwtPrincipalClaims) {
        this.jwtPrincipalClaims = jwtPrincipalClaims;
        return this;
    }

    @JsonProperty(value="jwtPrincipalClaimsMapping")
    public List<String> getJwtPrincipalClaimsMapping() {
        return this.jwtPrincipalClaimsMapping;
    }

    @JsonProperty(value="jwtPrincipalClaimsMapping")
    public void setJwtPrincipalClaimsMapping(List<String> jwtPrincipalClaimsMapping) {
        this.jwtPrincipalClaimsMapping = jwtPrincipalClaimsMapping;
    }

    public AuthenticationConfiguration withJwtPrincipalClaimsMapping(List<String> jwtPrincipalClaimsMapping) {
        this.jwtPrincipalClaimsMapping = jwtPrincipalClaimsMapping;
        return this;
    }

    @JsonProperty(value="enableSelfSignup")
    public Boolean getEnableSelfSignup() {
        return this.enableSelfSignup;
    }

    @JsonProperty(value="enableSelfSignup")
    public void setEnableSelfSignup(Boolean enableSelfSignup) {
        this.enableSelfSignup = enableSelfSignup;
    }

    public AuthenticationConfiguration withEnableSelfSignup(Boolean enableSelfSignup) {
        this.enableSelfSignup = enableSelfSignup;
        return this;
    }

    @JsonProperty(value="ldapConfiguration")
    public LdapConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    @JsonProperty(value="ldapConfiguration")
    public void setLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public AuthenticationConfiguration withLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
        return this;
    }

    @JsonProperty(value="samlConfiguration")
    public SamlSSOClientConfig getSamlConfiguration() {
        return this.samlConfiguration;
    }

    @JsonProperty(value="samlConfiguration")
    public void setSamlConfiguration(SamlSSOClientConfig samlConfiguration) {
        this.samlConfiguration = samlConfiguration;
    }

    public AuthenticationConfiguration withSamlConfiguration(SamlSSOClientConfig samlConfiguration) {
        this.samlConfiguration = samlConfiguration;
        return this;
    }

    @JsonProperty(value="oidcConfiguration")
    public OidcClientConfig getOidcConfiguration() {
        return this.oidcConfiguration;
    }

    @JsonProperty(value="oidcConfiguration")
    public void setOidcConfiguration(OidcClientConfig oidcConfiguration) {
        this.oidcConfiguration = oidcConfiguration;
    }

    public AuthenticationConfiguration withOidcConfiguration(OidcClientConfig oidcConfiguration) {
        this.oidcConfiguration = oidcConfiguration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthenticationConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clientType");
        sb.append('=');
        sb.append(this.clientType == null ? "<null>" : this.clientType);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(this.responseType == null ? "<null>" : this.responseType);
        sb.append(',');
        sb.append("providerName");
        sb.append('=');
        sb.append(this.providerName == null ? "<null>" : this.providerName);
        sb.append(',');
        sb.append("publicKeyUrls");
        sb.append('=');
        sb.append(this.publicKeyUrls == null ? "<null>" : this.publicKeyUrls);
        sb.append(',');
        sb.append("authority");
        sb.append('=');
        sb.append(this.authority == null ? "<null>" : this.authority);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("callbackUrl");
        sb.append('=');
        sb.append(this.callbackUrl == null ? "<null>" : this.callbackUrl);
        sb.append(',');
        sb.append("jwtPrincipalClaims");
        sb.append('=');
        sb.append(this.jwtPrincipalClaims == null ? "<null>" : this.jwtPrincipalClaims);
        sb.append(',');
        sb.append("jwtPrincipalClaimsMapping");
        sb.append('=');
        sb.append(this.jwtPrincipalClaimsMapping == null ? "<null>" : this.jwtPrincipalClaimsMapping);
        sb.append(',');
        sb.append("enableSelfSignup");
        sb.append('=');
        sb.append(this.enableSelfSignup == null ? "<null>" : this.enableSelfSignup);
        sb.append(',');
        sb.append("ldapConfiguration");
        sb.append('=');
        sb.append(this.ldapConfiguration == null ? "<null>" : this.ldapConfiguration);
        sb.append(',');
        sb.append("samlConfiguration");
        sb.append('=');
        sb.append(this.samlConfiguration == null ? "<null>" : this.samlConfiguration);
        sb.append(',');
        sb.append("oidcConfiguration");
        sb.append('=');
        sb.append(this.oidcConfiguration == null ? "<null>" : this.oidcConfiguration);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.samlConfiguration == null ? 0 : this.samlConfiguration.hashCode());
        result = result * 31 + (this.ldapConfiguration == null ? 0 : this.ldapConfiguration.hashCode());
        result = result * 31 + (this.jwtPrincipalClaimsMapping == null ? 0 : this.jwtPrincipalClaimsMapping.hashCode());
        result = result * 31 + (this.enableSelfSignup == null ? 0 : this.enableSelfSignup.hashCode());
        result = result * 31 + (this.responseType == null ? 0 : this.responseType.hashCode());
        result = result * 31 + (this.clientType == null ? 0 : this.clientType.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.publicKeyUrls == null ? 0 : this.publicKeyUrls.hashCode());
        result = result * 31 + (this.oidcConfiguration == null ? 0 : this.oidcConfiguration.hashCode());
        result = result * 31 + (this.authority == null ? 0 : this.authority.hashCode());
        result = result * 31 + (this.jwtPrincipalClaims == null ? 0 : this.jwtPrincipalClaims.hashCode());
        result = result * 31 + (this.callbackUrl == null ? 0 : this.callbackUrl.hashCode());
        result = result * 31 + (this.providerName == null ? 0 : this.providerName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration rhs = (AuthenticationConfiguration)other;
        return (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.samlConfiguration == rhs.samlConfiguration || this.samlConfiguration != null && this.samlConfiguration.equals(rhs.samlConfiguration)) && (this.ldapConfiguration == rhs.ldapConfiguration || this.ldapConfiguration != null && this.ldapConfiguration.equals(rhs.ldapConfiguration)) && (this.jwtPrincipalClaimsMapping == rhs.jwtPrincipalClaimsMapping || this.jwtPrincipalClaimsMapping != null && this.jwtPrincipalClaimsMapping.equals(rhs.jwtPrincipalClaimsMapping)) && (this.enableSelfSignup == rhs.enableSelfSignup || this.enableSelfSignup != null && this.enableSelfSignup.equals(rhs.enableSelfSignup)) && (this.responseType == rhs.responseType || this.responseType != null && this.responseType.equals((Object)rhs.responseType)) && (this.clientType == rhs.clientType || this.clientType != null && this.clientType.equals((Object)rhs.clientType)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.publicKeyUrls == rhs.publicKeyUrls || this.publicKeyUrls != null && this.publicKeyUrls.equals(rhs.publicKeyUrls)) && (this.oidcConfiguration == rhs.oidcConfiguration || this.oidcConfiguration != null && this.oidcConfiguration.equals(rhs.oidcConfiguration)) && (this.authority == rhs.authority || this.authority != null && this.authority.equals(rhs.authority)) && (this.jwtPrincipalClaims == rhs.jwtPrincipalClaims || this.jwtPrincipalClaims != null && this.jwtPrincipalClaims.equals(rhs.jwtPrincipalClaims)) && (this.callbackUrl == rhs.callbackUrl || this.callbackUrl != null && this.callbackUrl.equals(rhs.callbackUrl)) && (this.providerName == rhs.providerName || this.providerName != null && this.providerName.equals(rhs.providerName));
    }
}

