/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"className", "containerRequestFilter", "adminPrincipals", "botPrincipals", "testPrincipals", "allowedEmailRegistrationDomains", "principalDomain", "enforcePrincipalDomain", "enableSecureSocketConnection", "useRolesFromProvider"})
public class AuthorizerConfiguration {
    @JsonProperty(value="className")
    @JsonPropertyDescription(value="Class Name for authorizer.")
    @NotNull
    private String className;
    @JsonProperty(value="containerRequestFilter")
    @JsonPropertyDescription(value="Filter for the request authorization.")
    @NotNull
    private String containerRequestFilter;
    @JsonProperty(value="adminPrincipals")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of unique admin principals.")
    @Valid
    @NotNull
    private Set<String> adminPrincipals = new LinkedHashSet<String>();
    @JsonProperty(value="botPrincipals")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="**@Deprecated** List of unique bot principals")
    @Valid
    private Set<String> botPrincipals = null;
    @JsonProperty(value="testPrincipals")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of unique principals used as test users. **NOTE THIS IS ONLY FOR TEST SETUP AND NOT TO BE USED IN PRODUCTION SETUP**")
    @Valid
    private Set<String> testPrincipals = new LinkedHashSet<String>();
    @JsonProperty(value="allowedEmailRegistrationDomains")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of unique email domains that are allowed to signup on the platforms")
    @Valid
    private Set<String> allowedEmailRegistrationDomains = new LinkedHashSet<String>();
    @JsonProperty(value="principalDomain")
    @JsonPropertyDescription(value="Principal Domain")
    @NotNull
    private String principalDomain;
    @JsonProperty(value="enforcePrincipalDomain")
    @JsonPropertyDescription(value="Enable Enforce Principal Domain")
    @NotNull
    private Boolean enforcePrincipalDomain;
    @JsonProperty(value="enableSecureSocketConnection")
    @JsonPropertyDescription(value="Enable Secure Socket Connection.")
    @NotNull
    private Boolean enableSecureSocketConnection;
    @JsonProperty(value="useRolesFromProvider")
    @JsonPropertyDescription(value="Use Roles from Provider")
    private Boolean useRolesFromProvider = false;

    @JsonProperty(value="className")
    public String getClassName() {
        return this.className;
    }

    @JsonProperty(value="className")
    public void setClassName(String className) {
        this.className = className;
    }

    public AuthorizerConfiguration withClassName(String className) {
        this.className = className;
        return this;
    }

    @JsonProperty(value="containerRequestFilter")
    public String getContainerRequestFilter() {
        return this.containerRequestFilter;
    }

    @JsonProperty(value="containerRequestFilter")
    public void setContainerRequestFilter(String containerRequestFilter) {
        this.containerRequestFilter = containerRequestFilter;
    }

    public AuthorizerConfiguration withContainerRequestFilter(String containerRequestFilter) {
        this.containerRequestFilter = containerRequestFilter;
        return this;
    }

    @JsonProperty(value="adminPrincipals")
    public Set<String> getAdminPrincipals() {
        return this.adminPrincipals;
    }

    @JsonProperty(value="adminPrincipals")
    public void setAdminPrincipals(Set<String> adminPrincipals) {
        this.adminPrincipals = adminPrincipals;
    }

    public AuthorizerConfiguration withAdminPrincipals(Set<String> adminPrincipals) {
        this.adminPrincipals = adminPrincipals;
        return this;
    }

    @JsonProperty(value="botPrincipals")
    public Set<String> getBotPrincipals() {
        return this.botPrincipals;
    }

    @JsonProperty(value="botPrincipals")
    public void setBotPrincipals(Set<String> botPrincipals) {
        this.botPrincipals = botPrincipals;
    }

    public AuthorizerConfiguration withBotPrincipals(Set<String> botPrincipals) {
        this.botPrincipals = botPrincipals;
        return this;
    }

    @JsonProperty(value="testPrincipals")
    public Set<String> getTestPrincipals() {
        return this.testPrincipals;
    }

    @JsonProperty(value="testPrincipals")
    public void setTestPrincipals(Set<String> testPrincipals) {
        this.testPrincipals = testPrincipals;
    }

    public AuthorizerConfiguration withTestPrincipals(Set<String> testPrincipals) {
        this.testPrincipals = testPrincipals;
        return this;
    }

    @JsonProperty(value="allowedEmailRegistrationDomains")
    public Set<String> getAllowedEmailRegistrationDomains() {
        return this.allowedEmailRegistrationDomains;
    }

    @JsonProperty(value="allowedEmailRegistrationDomains")
    public void setAllowedEmailRegistrationDomains(Set<String> allowedEmailRegistrationDomains) {
        this.allowedEmailRegistrationDomains = allowedEmailRegistrationDomains;
    }

    public AuthorizerConfiguration withAllowedEmailRegistrationDomains(Set<String> allowedEmailRegistrationDomains) {
        this.allowedEmailRegistrationDomains = allowedEmailRegistrationDomains;
        return this;
    }

    @JsonProperty(value="principalDomain")
    public String getPrincipalDomain() {
        return this.principalDomain;
    }

    @JsonProperty(value="principalDomain")
    public void setPrincipalDomain(String principalDomain) {
        this.principalDomain = principalDomain;
    }

    public AuthorizerConfiguration withPrincipalDomain(String principalDomain) {
        this.principalDomain = principalDomain;
        return this;
    }

    @JsonProperty(value="enforcePrincipalDomain")
    public Boolean getEnforcePrincipalDomain() {
        return this.enforcePrincipalDomain;
    }

    @JsonProperty(value="enforcePrincipalDomain")
    public void setEnforcePrincipalDomain(Boolean enforcePrincipalDomain) {
        this.enforcePrincipalDomain = enforcePrincipalDomain;
    }

    public AuthorizerConfiguration withEnforcePrincipalDomain(Boolean enforcePrincipalDomain) {
        this.enforcePrincipalDomain = enforcePrincipalDomain;
        return this;
    }

    @JsonProperty(value="enableSecureSocketConnection")
    public Boolean getEnableSecureSocketConnection() {
        return this.enableSecureSocketConnection;
    }

    @JsonProperty(value="enableSecureSocketConnection")
    public void setEnableSecureSocketConnection(Boolean enableSecureSocketConnection) {
        this.enableSecureSocketConnection = enableSecureSocketConnection;
    }

    public AuthorizerConfiguration withEnableSecureSocketConnection(Boolean enableSecureSocketConnection) {
        this.enableSecureSocketConnection = enableSecureSocketConnection;
        return this;
    }

    @JsonProperty(value="useRolesFromProvider")
    public Boolean getUseRolesFromProvider() {
        return this.useRolesFromProvider;
    }

    @JsonProperty(value="useRolesFromProvider")
    public void setUseRolesFromProvider(Boolean useRolesFromProvider) {
        this.useRolesFromProvider = useRolesFromProvider;
    }

    public AuthorizerConfiguration withUseRolesFromProvider(Boolean useRolesFromProvider) {
        this.useRolesFromProvider = useRolesFromProvider;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthorizerConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("className");
        sb.append('=');
        sb.append(this.className == null ? "<null>" : this.className);
        sb.append(',');
        sb.append("containerRequestFilter");
        sb.append('=');
        sb.append(this.containerRequestFilter == null ? "<null>" : this.containerRequestFilter);
        sb.append(',');
        sb.append("adminPrincipals");
        sb.append('=');
        sb.append(this.adminPrincipals == null ? "<null>" : this.adminPrincipals);
        sb.append(',');
        sb.append("botPrincipals");
        sb.append('=');
        sb.append(this.botPrincipals == null ? "<null>" : this.botPrincipals);
        sb.append(',');
        sb.append("testPrincipals");
        sb.append('=');
        sb.append(this.testPrincipals == null ? "<null>" : this.testPrincipals);
        sb.append(',');
        sb.append("allowedEmailRegistrationDomains");
        sb.append('=');
        sb.append(this.allowedEmailRegistrationDomains == null ? "<null>" : this.allowedEmailRegistrationDomains);
        sb.append(',');
        sb.append("principalDomain");
        sb.append('=');
        sb.append(this.principalDomain == null ? "<null>" : this.principalDomain);
        sb.append(',');
        sb.append("enforcePrincipalDomain");
        sb.append('=');
        sb.append(this.enforcePrincipalDomain == null ? "<null>" : this.enforcePrincipalDomain);
        sb.append(',');
        sb.append("enableSecureSocketConnection");
        sb.append('=');
        sb.append(this.enableSecureSocketConnection == null ? "<null>" : this.enableSecureSocketConnection);
        sb.append(',');
        sb.append("useRolesFromProvider");
        sb.append('=');
        sb.append(this.useRolesFromProvider == null ? "<null>" : this.useRolesFromProvider);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.containerRequestFilter == null ? 0 : this.containerRequestFilter.hashCode());
        result = result * 31 + (this.enforcePrincipalDomain == null ? 0 : this.enforcePrincipalDomain.hashCode());
        result = result * 31 + (this.principalDomain == null ? 0 : this.principalDomain.hashCode());
        result = result * 31 + (this.adminPrincipals == null ? 0 : this.adminPrincipals.hashCode());
        result = result * 31 + (this.testPrincipals == null ? 0 : this.testPrincipals.hashCode());
        result = result * 31 + (this.useRolesFromProvider == null ? 0 : this.useRolesFromProvider.hashCode());
        result = result * 31 + (this.className == null ? 0 : this.className.hashCode());
        result = result * 31 + (this.allowedEmailRegistrationDomains == null ? 0 : this.allowedEmailRegistrationDomains.hashCode());
        result = result * 31 + (this.botPrincipals == null ? 0 : this.botPrincipals.hashCode());
        result = result * 31 + (this.enableSecureSocketConnection == null ? 0 : this.enableSecureSocketConnection.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthorizerConfiguration)) {
            return false;
        }
        AuthorizerConfiguration rhs = (AuthorizerConfiguration)other;
        return (this.containerRequestFilter == rhs.containerRequestFilter || this.containerRequestFilter != null && this.containerRequestFilter.equals(rhs.containerRequestFilter)) && (this.enforcePrincipalDomain == rhs.enforcePrincipalDomain || this.enforcePrincipalDomain != null && this.enforcePrincipalDomain.equals(rhs.enforcePrincipalDomain)) && (this.principalDomain == rhs.principalDomain || this.principalDomain != null && this.principalDomain.equals(rhs.principalDomain)) && (this.adminPrincipals == rhs.adminPrincipals || this.adminPrincipals != null && this.adminPrincipals.equals(rhs.adminPrincipals)) && (this.testPrincipals == rhs.testPrincipals || this.testPrincipals != null && this.testPrincipals.equals(rhs.testPrincipals)) && (this.useRolesFromProvider == rhs.useRolesFromProvider || this.useRolesFromProvider != null && this.useRolesFromProvider.equals(rhs.useRolesFromProvider)) && (this.className == rhs.className || this.className != null && this.className.equals(rhs.className)) && (this.allowedEmailRegistrationDomains == rhs.allowedEmailRegistrationDomains || this.allowedEmailRegistrationDomains != null && this.allowedEmailRegistrationDomains.equals(rhs.allowedEmailRegistrationDomains)) && (this.botPrincipals == rhs.botPrincipals || this.botPrincipals != null && this.botPrincipals.equals(rhs.botPrincipals)) && (this.enableSecureSocketConnection == rhs.enableSecureSocketConnection || this.enableSecureSocketConnection != null && this.enableSecureSocketConnection.equals(rhs.enableSecureSocketConnection));
    }
}

