/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ClientType {
    PUBLIC("public"),
    CONFIDENTIAL("confidential");

    private final String value;
    private static final Map<String, ClientType> CONSTANTS;

    private ClientType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ClientType fromValue(String value) {
        ClientType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ClientType>();
        for (ClientType c : ClientType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

