/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EnumInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.SearchConnection;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "serviceType", "connection", "tags", "owners", "dataProducts", "domain"})
public class CreateSearchService
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this search service. It could be title or label from the source services.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of search service such as ElasticSearch or OpenSearch.")
    @NotNull
    private SearchServiceType serviceType;
    @JsonProperty(value="connection")
    @JsonPropertyDescription(value="search Connection.")
    @Valid
    private SearchConnection connection;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this Search Service.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="List of fully qualified names of data products this entity is part of.")
    @Valid
    private List<String> dataProducts = new ArrayList<String>();
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Search Service belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateSearchService withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateSearchService withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateSearchService withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="serviceType")
    public SearchServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(SearchServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public CreateSearchService withServiceType(SearchServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="connection")
    public SearchConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    public void setConnection(SearchConnection connection) {
        this.connection = connection;
    }

    public CreateSearchService withConnection(SearchConnection connection) {
        this.connection = connection;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateSearchService withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateSearchService withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateSearchService withDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateSearchService withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateSearchService.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("connection");
        sb.append('=');
        sb.append(this.connection == null ? "<null>" : this.connection);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateSearchService)) {
            return false;
        }
        CreateSearchService rhs = (CreateSearchService)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.connection == rhs.connection || this.connection != null && this.connection.equals(rhs.connection)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }

    public static enum SearchServiceType implements EnumInterface
    {
        ElasticSearch("ElasticSearch"),
        OpenSearch("OpenSearch"),
        CustomSearch("CustomSearch");

        private final String value;
        private static final Map<String, SearchServiceType> CONSTANTS;

        private SearchServiceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SearchServiceType fromValue(String value) {
            SearchServiceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SearchServiceType>();
            for (SearchServiceType c : SearchServiceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

