/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.services.ingestionPipelines;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.services.ingestionPipelines.AirflowConfig;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.LogLevels;
import org.openmetadata.schema.metadataIngestion.SourceConfig;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "pipelineType", "sourceConfig", "airflowConfig", "loggerLevel", "service", "owners", "domain"})
public class CreateIngestionPipeline
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this ingestion pipeline.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="pipelineType")
    @JsonPropertyDescription(value="Type of Pipeline - metadata, usage")
    @NotNull
    private PipelineType pipelineType;
    @JsonProperty(value="sourceConfig")
    @JsonPropertyDescription(value="Additional connection configuration.")
    @Valid
    @NotNull
    private SourceConfig sourceConfig;
    @JsonProperty(value="airflowConfig")
    @JsonPropertyDescription(value="Properties to configure the Airflow pipeline that will run the workflow.")
    @Valid
    @NotNull
    private AirflowConfig airflowConfig;
    @JsonProperty(value="loggerLevel")
    @JsonPropertyDescription(value="Supported logging levels")
    private LogLevels loggerLevel = LogLevels.fromValue("INFO");
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference service;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateIngestionPipeline withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateIngestionPipeline withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateIngestionPipeline withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="pipelineType")
    public PipelineType getPipelineType() {
        return this.pipelineType;
    }

    @JsonProperty(value="pipelineType")
    public void setPipelineType(PipelineType pipelineType) {
        this.pipelineType = pipelineType;
    }

    public CreateIngestionPipeline withPipelineType(PipelineType pipelineType) {
        this.pipelineType = pipelineType;
        return this;
    }

    @JsonProperty(value="sourceConfig")
    public SourceConfig getSourceConfig() {
        return this.sourceConfig;
    }

    @JsonProperty(value="sourceConfig")
    public void setSourceConfig(SourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public CreateIngestionPipeline withSourceConfig(SourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
        return this;
    }

    @JsonProperty(value="airflowConfig")
    public AirflowConfig getAirflowConfig() {
        return this.airflowConfig;
    }

    @JsonProperty(value="airflowConfig")
    public void setAirflowConfig(AirflowConfig airflowConfig) {
        this.airflowConfig = airflowConfig;
    }

    public CreateIngestionPipeline withAirflowConfig(AirflowConfig airflowConfig) {
        this.airflowConfig = airflowConfig;
        return this;
    }

    @JsonProperty(value="loggerLevel")
    public LogLevels getLoggerLevel() {
        return this.loggerLevel;
    }

    @JsonProperty(value="loggerLevel")
    public void setLoggerLevel(LogLevels loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    public CreateIngestionPipeline withLoggerLevel(LogLevels loggerLevel) {
        this.loggerLevel = loggerLevel;
        return this;
    }

    @JsonProperty(value="service")
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(EntityReference service) {
        this.service = service;
    }

    public CreateIngestionPipeline withService(EntityReference service) {
        this.service = service;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateIngestionPipeline withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateIngestionPipeline withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateIngestionPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("pipelineType");
        sb.append('=');
        sb.append(this.pipelineType == null ? "<null>" : this.pipelineType);
        sb.append(',');
        sb.append("sourceConfig");
        sb.append('=');
        sb.append(this.sourceConfig == null ? "<null>" : this.sourceConfig);
        sb.append(',');
        sb.append("airflowConfig");
        sb.append('=');
        sb.append(this.airflowConfig == null ? "<null>" : this.airflowConfig);
        sb.append(',');
        sb.append("loggerLevel");
        sb.append('=');
        sb.append(this.loggerLevel == null ? "<null>" : this.loggerLevel);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourceConfig == null ? 0 : this.sourceConfig.hashCode());
        result = result * 31 + (this.airflowConfig == null ? 0 : this.airflowConfig.hashCode());
        result = result * 31 + (this.loggerLevel == null ? 0 : this.loggerLevel.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.pipelineType == null ? 0 : this.pipelineType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateIngestionPipeline)) {
            return false;
        }
        CreateIngestionPipeline rhs = (CreateIngestionPipeline)other;
        return (this.sourceConfig == rhs.sourceConfig || this.sourceConfig != null && this.sourceConfig.equals(rhs.sourceConfig)) && (this.airflowConfig == rhs.airflowConfig || this.airflowConfig != null && this.airflowConfig.equals(rhs.airflowConfig)) && (this.loggerLevel == rhs.loggerLevel || this.loggerLevel != null && this.loggerLevel.equals((Object)rhs.loggerLevel)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.pipelineType == rhs.pipelineType || this.pipelineType != null && this.pipelineType.equals((Object)rhs.pipelineType));
    }
}

