/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.teams;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Profile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "displayName", "email", "timezone", "isBot", "botName", "isAdmin", "profile", "teams", "roles", "personas", "defaultPersona", "authenticationMechanism", "createPasswordType", "password", "confirmPassword", "domains"})
public class CreateUser
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Name used for display purposes. Example 'FirstName LastName'")
    private String displayName;
    @Email
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    @NotNull
    private @Email @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$") @Size(min=6, max=127) @NotNull String email;
    @JsonProperty(value="timezone")
    @JsonPropertyDescription(value="Timezone of the user")
    private String timezone;
    @JsonProperty(value="isBot")
    @JsonPropertyDescription(value="When true indicates user is a bot with appropriate privileges")
    private Boolean isBot = false;
    @JsonProperty(value="botName")
    @JsonPropertyDescription(value="User bot name if we want to associate this bot with an specific bot")
    private String botName;
    @JsonProperty(value="isAdmin")
    @JsonPropertyDescription(value="When true indicates user is an administrator for the system with superuser privileges")
    private Boolean isAdmin = false;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="This schema defines the type for a profile of a user, team, or organization.")
    @Valid
    private Profile profile;
    @JsonProperty(value="teams")
    @JsonPropertyDescription(value="Teams that the user belongs to")
    @Valid
    private List<UUID> teams = null;
    @JsonProperty(value="roles")
    @JsonPropertyDescription(value="Roles that the user has been assigned")
    @Valid
    private List<UUID> roles = null;
    @JsonProperty(value="personas")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> personas = null;
    @JsonProperty(value="defaultPersona")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference defaultPersona;
    @JsonProperty(value="authenticationMechanism")
    @JsonPropertyDescription(value="User/Bot Authentication Mechanism.")
    @Valid
    private AuthenticationMechanism authenticationMechanism;
    @JsonProperty(value="createPasswordType")
    @JsonPropertyDescription(value="User Password Method")
    private CreatePasswordType createPasswordType = CreatePasswordType.fromValue("USER_CREATE");
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password for User")
    private String password;
    @JsonProperty(value="confirmPassword")
    @JsonPropertyDescription(value="Confirm Password for User")
    private String confirmPassword;
    @JsonProperty(value="domains")
    @JsonPropertyDescription(value="Domains the User belongs to.")
    @Valid
    private List<String> domains = null;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateUser withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateUser withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateUser withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public CreateUser withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public CreateUser withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @JsonProperty(value="isBot")
    public Boolean getIsBot() {
        return this.isBot;
    }

    @JsonProperty(value="isBot")
    public void setIsBot(Boolean isBot) {
        this.isBot = isBot;
    }

    public CreateUser withIsBot(Boolean isBot) {
        this.isBot = isBot;
        return this;
    }

    @JsonProperty(value="botName")
    public String getBotName() {
        return this.botName;
    }

    @JsonProperty(value="botName")
    public void setBotName(String botName) {
        this.botName = botName;
    }

    public CreateUser withBotName(String botName) {
        this.botName = botName;
        return this;
    }

    @JsonProperty(value="isAdmin")
    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    @JsonProperty(value="isAdmin")
    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public CreateUser withIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
        return this;
    }

    @JsonProperty(value="profile")
    public Profile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public CreateUser withProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @JsonProperty(value="teams")
    public List<UUID> getTeams() {
        return this.teams;
    }

    @JsonProperty(value="teams")
    public void setTeams(List<UUID> teams) {
        this.teams = teams;
    }

    public CreateUser withTeams(List<UUID> teams) {
        this.teams = teams;
        return this;
    }

    @JsonProperty(value="roles")
    public List<UUID> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    public void setRoles(List<UUID> roles) {
        this.roles = roles;
    }

    public CreateUser withRoles(List<UUID> roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="personas")
    public List<EntityReference> getPersonas() {
        return this.personas;
    }

    @JsonProperty(value="personas")
    public void setPersonas(List<EntityReference> personas) {
        this.personas = personas;
    }

    public CreateUser withPersonas(List<EntityReference> personas) {
        this.personas = personas;
        return this;
    }

    @JsonProperty(value="defaultPersona")
    public EntityReference getDefaultPersona() {
        return this.defaultPersona;
    }

    @JsonProperty(value="defaultPersona")
    public void setDefaultPersona(EntityReference defaultPersona) {
        this.defaultPersona = defaultPersona;
    }

    public CreateUser withDefaultPersona(EntityReference defaultPersona) {
        this.defaultPersona = defaultPersona;
        return this;
    }

    @JsonProperty(value="authenticationMechanism")
    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    @JsonProperty(value="authenticationMechanism")
    public void setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
    }

    public CreateUser withAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
        return this;
    }

    @JsonProperty(value="createPasswordType")
    public CreatePasswordType getCreatePasswordType() {
        return this.createPasswordType;
    }

    @JsonProperty(value="createPasswordType")
    public void setCreatePasswordType(CreatePasswordType createPasswordType) {
        this.createPasswordType = createPasswordType;
    }

    public CreateUser withCreatePasswordType(CreatePasswordType createPasswordType) {
        this.createPasswordType = createPasswordType;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public CreateUser withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="confirmPassword")
    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    @JsonProperty(value="confirmPassword")
    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public CreateUser withConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
        return this;
    }

    @JsonProperty(value="domains")
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public CreateUser withDomains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateUser.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("timezone");
        sb.append('=');
        sb.append(this.timezone == null ? "<null>" : this.timezone);
        sb.append(',');
        sb.append("isBot");
        sb.append('=');
        sb.append(this.isBot == null ? "<null>" : this.isBot);
        sb.append(',');
        sb.append("botName");
        sb.append('=');
        sb.append(this.botName == null ? "<null>" : this.botName);
        sb.append(',');
        sb.append("isAdmin");
        sb.append('=');
        sb.append(this.isAdmin == null ? "<null>" : this.isAdmin);
        sb.append(',');
        sb.append("profile");
        sb.append('=');
        sb.append(this.profile == null ? "<null>" : this.profile);
        sb.append(',');
        sb.append("teams");
        sb.append('=');
        sb.append(this.teams == null ? "<null>" : this.teams);
        sb.append(',');
        sb.append("roles");
        sb.append('=');
        sb.append(this.roles == null ? "<null>" : this.roles);
        sb.append(',');
        sb.append("personas");
        sb.append('=');
        sb.append(this.personas == null ? "<null>" : this.personas);
        sb.append(',');
        sb.append("defaultPersona");
        sb.append('=');
        sb.append(this.defaultPersona == null ? "<null>" : this.defaultPersona);
        sb.append(',');
        sb.append("authenticationMechanism");
        sb.append('=');
        sb.append(this.authenticationMechanism == null ? "<null>" : this.authenticationMechanism);
        sb.append(',');
        sb.append("createPasswordType");
        sb.append('=');
        sb.append(this.createPasswordType == null ? "<null>" : this.createPasswordType);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("confirmPassword");
        sb.append('=');
        sb.append(this.confirmPassword == null ? "<null>" : this.confirmPassword);
        sb.append(',');
        sb.append("domains");
        sb.append('=');
        sb.append(this.domains == null ? "<null>" : this.domains);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.isBot == null ? 0 : this.isBot.hashCode());
        result = result * 31 + (this.teams == null ? 0 : this.teams.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.timezone == null ? 0 : this.timezone.hashCode());
        result = result * 31 + (this.botName == null ? 0 : this.botName.hashCode());
        result = result * 31 + (this.profile == null ? 0 : this.profile.hashCode());
        result = result * 31 + (this.roles == null ? 0 : this.roles.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.domains == null ? 0 : this.domains.hashCode());
        result = result * 31 + (this.isAdmin == null ? 0 : this.isAdmin.hashCode());
        result = result * 31 + (this.personas == null ? 0 : this.personas.hashCode());
        result = result * 31 + (this.defaultPersona == null ? 0 : this.defaultPersona.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.createPasswordType == null ? 0 : this.createPasswordType.hashCode());
        result = result * 31 + (this.confirmPassword == null ? 0 : this.confirmPassword.hashCode());
        result = result * 31 + (this.authenticationMechanism == null ? 0 : this.authenticationMechanism.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateUser)) {
            return false;
        }
        CreateUser rhs = (CreateUser)other;
        return (this.isBot == rhs.isBot || this.isBot != null && this.isBot.equals(rhs.isBot)) && (this.teams == rhs.teams || this.teams != null && this.teams.equals(rhs.teams)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.timezone == rhs.timezone || this.timezone != null && this.timezone.equals(rhs.timezone)) && (this.botName == rhs.botName || this.botName != null && this.botName.equals(rhs.botName)) && (this.profile == rhs.profile || this.profile != null && this.profile.equals(rhs.profile)) && (this.roles == rhs.roles || this.roles != null && this.roles.equals(rhs.roles)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.domains == rhs.domains || this.domains != null && this.domains.equals(rhs.domains)) && (this.isAdmin == rhs.isAdmin || this.isAdmin != null && this.isAdmin.equals(rhs.isAdmin)) && (this.personas == rhs.personas || this.personas != null && this.personas.equals(rhs.personas)) && (this.defaultPersona == rhs.defaultPersona || this.defaultPersona != null && this.defaultPersona.equals(rhs.defaultPersona)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.createPasswordType == rhs.createPasswordType || this.createPasswordType != null && this.createPasswordType.equals((Object)rhs.createPasswordType)) && (this.confirmPassword == rhs.confirmPassword || this.confirmPassword != null && this.confirmPassword.equals(rhs.confirmPassword)) && (this.authenticationMechanism == rhs.authenticationMechanism || this.authenticationMechanism != null && this.authenticationMechanism.equals(rhs.authenticationMechanism)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email));
    }

    public static enum CreatePasswordType {
        ADMIN_CREATE("ADMIN_CREATE"),
        USER_CREATE("USER_CREATE");

        private final String value;
        private static final Map<String, CreatePasswordType> CONSTANTS;

        private CreatePasswordType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CreatePasswordType fromValue(String value) {
            CreatePasswordType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CreatePasswordType>();
            for (CreatePasswordType c : CreatePasswordType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

