/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"email", "password"})
public class BasicLoginRequest {
    @Email
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    @NotNull
    private @Email @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$") @Size(min=6, max=127) @NotNull String email;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Name of the column in a table.")
    @NotNull
    private String password;

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public BasicLoginRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public BasicLoginRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BasicLoginRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BasicLoginRequest)) {
            return false;
        }
        BasicLoginRequest rhs = (BasicLoginRequest)other;
        return (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password));
    }
}

