/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"username", "oldPassword", "newPassword", "confirmPassword", "requestType"})
public class ChangePasswordRequest {
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Name of the user")
    private String username;
    @JsonProperty(value="oldPassword")
    @JsonPropertyDescription(value="Name that identifies this Custom Metric.")
    private String oldPassword;
    @JsonProperty(value="newPassword")
    @JsonPropertyDescription(value="Name of the column in a table.")
    @NotNull
    private String newPassword;
    @JsonProperty(value="confirmPassword")
    @JsonPropertyDescription(value="Name of the column in a table.")
    @NotNull
    private String confirmPassword;
    @JsonProperty(value="requestType")
    @JsonPropertyDescription(value="Name of the column in a table.")
    private RequestType requestType = RequestType.fromValue("SELF");

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public ChangePasswordRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="oldPassword")
    public String getOldPassword() {
        return this.oldPassword;
    }

    @JsonProperty(value="oldPassword")
    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public ChangePasswordRequest withOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
        return this;
    }

    @JsonProperty(value="newPassword")
    public String getNewPassword() {
        return this.newPassword;
    }

    @JsonProperty(value="newPassword")
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public ChangePasswordRequest withNewPassword(String newPassword) {
        this.newPassword = newPassword;
        return this;
    }

    @JsonProperty(value="confirmPassword")
    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    @JsonProperty(value="confirmPassword")
    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public ChangePasswordRequest withConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
        return this;
    }

    @JsonProperty(value="requestType")
    public RequestType getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public ChangePasswordRequest withRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChangePasswordRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("oldPassword");
        sb.append('=');
        sb.append(this.oldPassword == null ? "<null>" : this.oldPassword);
        sb.append(',');
        sb.append("newPassword");
        sb.append('=');
        sb.append(this.newPassword == null ? "<null>" : this.newPassword);
        sb.append(',');
        sb.append("confirmPassword");
        sb.append('=');
        sb.append(this.confirmPassword == null ? "<null>" : this.confirmPassword);
        sb.append(',');
        sb.append("requestType");
        sb.append('=');
        sb.append(this.requestType == null ? "<null>" : this.requestType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.newPassword == null ? 0 : this.newPassword.hashCode());
        result = result * 31 + (this.confirmPassword == null ? 0 : this.confirmPassword.hashCode());
        result = result * 31 + (this.requestType == null ? 0 : this.requestType.hashCode());
        result = result * 31 + (this.oldPassword == null ? 0 : this.oldPassword.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChangePasswordRequest)) {
            return false;
        }
        ChangePasswordRequest rhs = (ChangePasswordRequest)other;
        return (this.newPassword == rhs.newPassword || this.newPassword != null && this.newPassword.equals(rhs.newPassword)) && (this.confirmPassword == rhs.confirmPassword || this.confirmPassword != null && this.confirmPassword.equals(rhs.confirmPassword)) && (this.requestType == rhs.requestType || this.requestType != null && this.requestType.equals((Object)rhs.requestType)) && (this.oldPassword == rhs.oldPassword || this.oldPassword != null && this.oldPassword.equals(rhs.oldPassword)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum RequestType {
        SELF("SELF"),
        USER("USER");

        private final String value;
        private static final Map<String, RequestType> CONSTANTS;

        private RequestType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RequestType fromValue(String value) {
            RequestType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RequestType>();
            for (RequestType c : RequestType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

