/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.auth.TokenType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"token", "userId", "tokenType", "tokenStatus", "expiryDate"})
public class EmailVerificationToken
implements TokenInterface {
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID token;
    @JsonProperty(value="userId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID userId;
    @JsonProperty(value="tokenType")
    @JsonPropertyDescription(value="Different Type of User token")
    @NotNull
    private TokenType tokenType;
    @JsonProperty(value="tokenStatus")
    @JsonPropertyDescription(value="Refresh Count")
    @NotNull
    private TokenStatus tokenStatus;
    @JsonProperty(value="expiryDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long expiryDate;

    @Override
    @JsonProperty(value="token")
    public UUID getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="token")
    public void setToken(UUID token) {
        this.token = token;
    }

    public EmailVerificationToken withToken(UUID token) {
        this.token = token;
        return this;
    }

    @Override
    @JsonProperty(value="userId")
    public UUID getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="userId")
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public EmailVerificationToken withUserId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Override
    @JsonProperty(value="tokenType")
    public TokenType getTokenType() {
        return this.tokenType;
    }

    @Override
    @JsonProperty(value="tokenType")
    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public EmailVerificationToken withTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @JsonProperty(value="tokenStatus")
    public TokenStatus getTokenStatus() {
        return this.tokenStatus;
    }

    @JsonProperty(value="tokenStatus")
    public void setTokenStatus(TokenStatus tokenStatus) {
        this.tokenStatus = tokenStatus;
    }

    public EmailVerificationToken withTokenStatus(TokenStatus tokenStatus) {
        this.tokenStatus = tokenStatus;
        return this;
    }

    @Override
    @JsonProperty(value="expiryDate")
    public Long getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    @JsonProperty(value="expiryDate")
    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public EmailVerificationToken withExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EmailVerificationToken.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(this.userId == null ? "<null>" : this.userId);
        sb.append(',');
        sb.append("tokenType");
        sb.append('=');
        sb.append(this.tokenType == null ? "<null>" : this.tokenType);
        sb.append(',');
        sb.append("tokenStatus");
        sb.append('=');
        sb.append(this.tokenStatus == null ? "<null>" : this.tokenStatus);
        sb.append(',');
        sb.append("expiryDate");
        sb.append('=');
        sb.append(this.expiryDate == null ? "<null>" : this.expiryDate);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.expiryDate == null ? 0 : this.expiryDate.hashCode());
        result = result * 31 + (this.tokenStatus == null ? 0 : this.tokenStatus.hashCode());
        result = result * 31 + (this.tokenType == null ? 0 : this.tokenType.hashCode());
        result = result * 31 + (this.userId == null ? 0 : this.userId.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EmailVerificationToken)) {
            return false;
        }
        EmailVerificationToken rhs = (EmailVerificationToken)other;
        return (this.expiryDate == rhs.expiryDate || this.expiryDate != null && this.expiryDate.equals(rhs.expiryDate)) && (this.tokenStatus == rhs.tokenStatus || this.tokenStatus != null && this.tokenStatus.equals((Object)rhs.tokenStatus)) && (this.tokenType == rhs.tokenType || this.tokenType != null && this.tokenType.equals((Object)rhs.tokenType)) && (this.userId == rhs.userId || this.userId != null && this.userId.equals(rhs.userId)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }

    public static enum TokenStatus {
        STATUS_PENDING("STATUS_PENDING"),
        STATUS_CONFIRMED("STATUS_CONFIRMED");

        private final String value;
        private static final Map<String, TokenStatus> CONSTANTS;

        private TokenStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TokenStatus fromValue(String value) {
            TokenStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TokenStatus>();
            for (TokenStatus c : TokenStatus.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

