/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JWTTokenExpiry {
    OneHour("OneHour"),
    One("1"),
    Seven("7"),
    Thirty("30"),
    Sixty("60"),
    Ninety("90"),
    Unlimited("Unlimited");

    private final String value;
    private static final Map<String, JWTTokenExpiry> CONSTANTS;

    private JWTTokenExpiry(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static JWTTokenExpiry fromValue(String value) {
        JWTTokenExpiry constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JWTTokenExpiry>();
        for (JWTTokenExpiry c : JWTTokenExpiry.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

