/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.auth.ldapTrustStoreConfig.TruststoreConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"host", "port", "maxPoolSize", "isFullDn", "dnAdminPrincipal", "dnAdminPassword", "sslEnabled", "userBaseDN", "groupBaseDN", "roleAdminName", "allAttributeName", "mailAttributeName", "usernameAttributeName", "groupAttributeName", "groupAttributeValue", "groupMemberAttributeName", "authRolesMapping", "authReassignRoles", "truststoreFormat", "truststoreConfigType", "trustStoreConfig"})
public class LdapConfiguration {
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="LDAP server address without scheme(Example :- localhost)")
    @NotNull
    private String host;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="Port of the server")
    @NotNull
    private Integer port;
    @JsonProperty(value="maxPoolSize")
    @JsonPropertyDescription(value="No of connection to create the pool with")
    private Integer maxPoolSize = 3;
    @JsonProperty(value="isFullDn")
    @JsonPropertyDescription(value="If enable need to give full dn to login")
    private Boolean isFullDn = false;
    @JsonProperty(value="dnAdminPrincipal")
    @JsonPropertyDescription(value="Distinguished Admin name with search capabilities")
    @NotNull
    private String dnAdminPrincipal;
    @JsonProperty(value="dnAdminPassword")
    @JsonPropertyDescription(value="Password for LDAP Admin")
    @NotNull
    private String dnAdminPassword;
    @JsonProperty(value="sslEnabled")
    @JsonPropertyDescription(value="LDAPS (secure LDAP) or LDAP")
    private Boolean sslEnabled = false;
    @JsonProperty(value="userBaseDN")
    @JsonPropertyDescription(value="User base distinguished name")
    @NotNull
    private String userBaseDN;
    @JsonProperty(value="groupBaseDN")
    @JsonPropertyDescription(value="Group base distinguished name")
    private String groupBaseDN;
    @JsonProperty(value="roleAdminName")
    @JsonPropertyDescription(value="Admin role name")
    private String roleAdminName;
    @JsonProperty(value="allAttributeName")
    @JsonPropertyDescription(value="All attribute name")
    private String allAttributeName;
    @JsonProperty(value="mailAttributeName")
    @JsonPropertyDescription(value="Email attribute name")
    @NotNull
    private String mailAttributeName;
    @JsonProperty(value="usernameAttributeName")
    @JsonPropertyDescription(value="User Name attribute name")
    private String usernameAttributeName;
    @JsonProperty(value="groupAttributeName")
    @JsonPropertyDescription(value="Group Name attribute name")
    private String groupAttributeName;
    @JsonProperty(value="groupAttributeValue")
    @JsonPropertyDescription(value="Group attribute value")
    private String groupAttributeValue;
    @JsonProperty(value="groupMemberAttributeName")
    @JsonPropertyDescription(value="Group Member Name attribute name")
    private String groupMemberAttributeName;
    @JsonProperty(value="authRolesMapping")
    @JsonPropertyDescription(value="Json string of roles mapping between LDAP roles and Ranger roles")
    private String authRolesMapping;
    @JsonProperty(value="authReassignRoles")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Roles should be reassign every time user login")
    @Valid
    private Set<String> authReassignRoles = new LinkedHashSet<String>();
    @JsonProperty(value="truststoreFormat")
    @JsonPropertyDescription(value="Truststore format e.g. PKCS12, JKS.")
    private String truststoreFormat;
    @JsonProperty(value="truststoreConfigType")
    @JsonPropertyDescription(value="Truststore Type e.g. TrustAll, HostName, JVMDefault, CustomTrustStore.")
    private TruststoreConfigType truststoreConfigType;
    @JsonProperty(value="trustStoreConfig")
    @JsonPropertyDescription(value="Truststore Configuration")
    @Valid
    private TruststoreConfig trustStoreConfig;

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public LdapConfiguration withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public LdapConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="maxPoolSize")
    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @JsonProperty(value="maxPoolSize")
    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public LdapConfiguration withMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    @JsonProperty(value="isFullDn")
    public Boolean getIsFullDn() {
        return this.isFullDn;
    }

    @JsonProperty(value="isFullDn")
    public void setIsFullDn(Boolean isFullDn) {
        this.isFullDn = isFullDn;
    }

    public LdapConfiguration withIsFullDn(Boolean isFullDn) {
        this.isFullDn = isFullDn;
        return this;
    }

    @JsonProperty(value="dnAdminPrincipal")
    public String getDnAdminPrincipal() {
        return this.dnAdminPrincipal;
    }

    @JsonProperty(value="dnAdminPrincipal")
    public void setDnAdminPrincipal(String dnAdminPrincipal) {
        this.dnAdminPrincipal = dnAdminPrincipal;
    }

    public LdapConfiguration withDnAdminPrincipal(String dnAdminPrincipal) {
        this.dnAdminPrincipal = dnAdminPrincipal;
        return this;
    }

    @JsonProperty(value="dnAdminPassword")
    public String getDnAdminPassword() {
        return this.dnAdminPassword;
    }

    @JsonProperty(value="dnAdminPassword")
    public void setDnAdminPassword(String dnAdminPassword) {
        this.dnAdminPassword = dnAdminPassword;
    }

    public LdapConfiguration withDnAdminPassword(String dnAdminPassword) {
        this.dnAdminPassword = dnAdminPassword;
        return this;
    }

    @JsonProperty(value="sslEnabled")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @JsonProperty(value="sslEnabled")
    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public LdapConfiguration withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @JsonProperty(value="userBaseDN")
    public String getUserBaseDN() {
        return this.userBaseDN;
    }

    @JsonProperty(value="userBaseDN")
    public void setUserBaseDN(String userBaseDN) {
        this.userBaseDN = userBaseDN;
    }

    public LdapConfiguration withUserBaseDN(String userBaseDN) {
        this.userBaseDN = userBaseDN;
        return this;
    }

    @JsonProperty(value="groupBaseDN")
    public String getGroupBaseDN() {
        return this.groupBaseDN;
    }

    @JsonProperty(value="groupBaseDN")
    public void setGroupBaseDN(String groupBaseDN) {
        this.groupBaseDN = groupBaseDN;
    }

    public LdapConfiguration withGroupBaseDN(String groupBaseDN) {
        this.groupBaseDN = groupBaseDN;
        return this;
    }

    @JsonProperty(value="roleAdminName")
    public String getRoleAdminName() {
        return this.roleAdminName;
    }

    @JsonProperty(value="roleAdminName")
    public void setRoleAdminName(String roleAdminName) {
        this.roleAdminName = roleAdminName;
    }

    public LdapConfiguration withRoleAdminName(String roleAdminName) {
        this.roleAdminName = roleAdminName;
        return this;
    }

    @JsonProperty(value="allAttributeName")
    public String getAllAttributeName() {
        return this.allAttributeName;
    }

    @JsonProperty(value="allAttributeName")
    public void setAllAttributeName(String allAttributeName) {
        this.allAttributeName = allAttributeName;
    }

    public LdapConfiguration withAllAttributeName(String allAttributeName) {
        this.allAttributeName = allAttributeName;
        return this;
    }

    @JsonProperty(value="mailAttributeName")
    public String getMailAttributeName() {
        return this.mailAttributeName;
    }

    @JsonProperty(value="mailAttributeName")
    public void setMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
    }

    public LdapConfiguration withMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
        return this;
    }

    @JsonProperty(value="usernameAttributeName")
    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    @JsonProperty(value="usernameAttributeName")
    public void setUsernameAttributeName(String usernameAttributeName) {
        this.usernameAttributeName = usernameAttributeName;
    }

    public LdapConfiguration withUsernameAttributeName(String usernameAttributeName) {
        this.usernameAttributeName = usernameAttributeName;
        return this;
    }

    @JsonProperty(value="groupAttributeName")
    public String getGroupAttributeName() {
        return this.groupAttributeName;
    }

    @JsonProperty(value="groupAttributeName")
    public void setGroupAttributeName(String groupAttributeName) {
        this.groupAttributeName = groupAttributeName;
    }

    public LdapConfiguration withGroupAttributeName(String groupAttributeName) {
        this.groupAttributeName = groupAttributeName;
        return this;
    }

    @JsonProperty(value="groupAttributeValue")
    public String getGroupAttributeValue() {
        return this.groupAttributeValue;
    }

    @JsonProperty(value="groupAttributeValue")
    public void setGroupAttributeValue(String groupAttributeValue) {
        this.groupAttributeValue = groupAttributeValue;
    }

    public LdapConfiguration withGroupAttributeValue(String groupAttributeValue) {
        this.groupAttributeValue = groupAttributeValue;
        return this;
    }

    @JsonProperty(value="groupMemberAttributeName")
    public String getGroupMemberAttributeName() {
        return this.groupMemberAttributeName;
    }

    @JsonProperty(value="groupMemberAttributeName")
    public void setGroupMemberAttributeName(String groupMemberAttributeName) {
        this.groupMemberAttributeName = groupMemberAttributeName;
    }

    public LdapConfiguration withGroupMemberAttributeName(String groupMemberAttributeName) {
        this.groupMemberAttributeName = groupMemberAttributeName;
        return this;
    }

    @JsonProperty(value="authRolesMapping")
    public String getAuthRolesMapping() {
        return this.authRolesMapping;
    }

    @JsonProperty(value="authRolesMapping")
    public void setAuthRolesMapping(String authRolesMapping) {
        this.authRolesMapping = authRolesMapping;
    }

    public LdapConfiguration withAuthRolesMapping(String authRolesMapping) {
        this.authRolesMapping = authRolesMapping;
        return this;
    }

    @JsonProperty(value="authReassignRoles")
    public Set<String> getAuthReassignRoles() {
        return this.authReassignRoles;
    }

    @JsonProperty(value="authReassignRoles")
    public void setAuthReassignRoles(Set<String> authReassignRoles) {
        this.authReassignRoles = authReassignRoles;
    }

    public LdapConfiguration withAuthReassignRoles(Set<String> authReassignRoles) {
        this.authReassignRoles = authReassignRoles;
        return this;
    }

    @JsonProperty(value="truststoreFormat")
    public String getTruststoreFormat() {
        return this.truststoreFormat;
    }

    @JsonProperty(value="truststoreFormat")
    public void setTruststoreFormat(String truststoreFormat) {
        this.truststoreFormat = truststoreFormat;
    }

    public LdapConfiguration withTruststoreFormat(String truststoreFormat) {
        this.truststoreFormat = truststoreFormat;
        return this;
    }

    @JsonProperty(value="truststoreConfigType")
    public TruststoreConfigType getTruststoreConfigType() {
        return this.truststoreConfigType;
    }

    @JsonProperty(value="truststoreConfigType")
    public void setTruststoreConfigType(TruststoreConfigType truststoreConfigType) {
        this.truststoreConfigType = truststoreConfigType;
    }

    public LdapConfiguration withTruststoreConfigType(TruststoreConfigType truststoreConfigType) {
        this.truststoreConfigType = truststoreConfigType;
        return this;
    }

    @JsonProperty(value="trustStoreConfig")
    public TruststoreConfig getTrustStoreConfig() {
        return this.trustStoreConfig;
    }

    @JsonProperty(value="trustStoreConfig")
    public void setTrustStoreConfig(TruststoreConfig trustStoreConfig) {
        this.trustStoreConfig = trustStoreConfig;
    }

    public LdapConfiguration withTrustStoreConfig(TruststoreConfig trustStoreConfig) {
        this.trustStoreConfig = trustStoreConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LdapConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(this.port == null ? "<null>" : this.port);
        sb.append(',');
        sb.append("maxPoolSize");
        sb.append('=');
        sb.append(this.maxPoolSize == null ? "<null>" : this.maxPoolSize);
        sb.append(',');
        sb.append("isFullDn");
        sb.append('=');
        sb.append(this.isFullDn == null ? "<null>" : this.isFullDn);
        sb.append(',');
        sb.append("dnAdminPrincipal");
        sb.append('=');
        sb.append(this.dnAdminPrincipal == null ? "<null>" : this.dnAdminPrincipal);
        sb.append(',');
        sb.append("dnAdminPassword");
        sb.append('=');
        sb.append(this.dnAdminPassword == null ? "<null>" : this.dnAdminPassword);
        sb.append(',');
        sb.append("sslEnabled");
        sb.append('=');
        sb.append(this.sslEnabled == null ? "<null>" : this.sslEnabled);
        sb.append(',');
        sb.append("userBaseDN");
        sb.append('=');
        sb.append(this.userBaseDN == null ? "<null>" : this.userBaseDN);
        sb.append(',');
        sb.append("groupBaseDN");
        sb.append('=');
        sb.append(this.groupBaseDN == null ? "<null>" : this.groupBaseDN);
        sb.append(',');
        sb.append("roleAdminName");
        sb.append('=');
        sb.append(this.roleAdminName == null ? "<null>" : this.roleAdminName);
        sb.append(',');
        sb.append("allAttributeName");
        sb.append('=');
        sb.append(this.allAttributeName == null ? "<null>" : this.allAttributeName);
        sb.append(',');
        sb.append("mailAttributeName");
        sb.append('=');
        sb.append(this.mailAttributeName == null ? "<null>" : this.mailAttributeName);
        sb.append(',');
        sb.append("usernameAttributeName");
        sb.append('=');
        sb.append(this.usernameAttributeName == null ? "<null>" : this.usernameAttributeName);
        sb.append(',');
        sb.append("groupAttributeName");
        sb.append('=');
        sb.append(this.groupAttributeName == null ? "<null>" : this.groupAttributeName);
        sb.append(',');
        sb.append("groupAttributeValue");
        sb.append('=');
        sb.append(this.groupAttributeValue == null ? "<null>" : this.groupAttributeValue);
        sb.append(',');
        sb.append("groupMemberAttributeName");
        sb.append('=');
        sb.append(this.groupMemberAttributeName == null ? "<null>" : this.groupMemberAttributeName);
        sb.append(',');
        sb.append("authRolesMapping");
        sb.append('=');
        sb.append(this.authRolesMapping == null ? "<null>" : this.authRolesMapping);
        sb.append(',');
        sb.append("authReassignRoles");
        sb.append('=');
        sb.append(this.authReassignRoles == null ? "<null>" : this.authReassignRoles);
        sb.append(',');
        sb.append("truststoreFormat");
        sb.append('=');
        sb.append(this.truststoreFormat == null ? "<null>" : this.truststoreFormat);
        sb.append(',');
        sb.append("truststoreConfigType");
        sb.append('=');
        sb.append(this.truststoreConfigType == null ? "<null>" : this.truststoreConfigType);
        sb.append(',');
        sb.append("trustStoreConfig");
        sb.append('=');
        sb.append(this.trustStoreConfig == null ? "<null>" : this.trustStoreConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.allAttributeName == null ? 0 : this.allAttributeName.hashCode());
        result = result * 31 + (this.truststoreConfigType == null ? 0 : this.truststoreConfigType.hashCode());
        result = result * 31 + (this.usernameAttributeName == null ? 0 : this.usernameAttributeName.hashCode());
        result = result * 31 + (this.authRolesMapping == null ? 0 : this.authRolesMapping.hashCode());
        result = result * 31 + (this.groupAttributeName == null ? 0 : this.groupAttributeName.hashCode());
        result = result * 31 + (this.groupBaseDN == null ? 0 : this.groupBaseDN.hashCode());
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.roleAdminName == null ? 0 : this.roleAdminName.hashCode());
        result = result * 31 + (this.mailAttributeName == null ? 0 : this.mailAttributeName.hashCode());
        result = result * 31 + (this.truststoreFormat == null ? 0 : this.truststoreFormat.hashCode());
        result = result * 31 + (this.trustStoreConfig == null ? 0 : this.trustStoreConfig.hashCode());
        result = result * 31 + (this.dnAdminPassword == null ? 0 : this.dnAdminPassword.hashCode());
        result = result * 31 + (this.sslEnabled == null ? 0 : this.sslEnabled.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.dnAdminPrincipal == null ? 0 : this.dnAdminPrincipal.hashCode());
        result = result * 31 + (this.authReassignRoles == null ? 0 : this.authReassignRoles.hashCode());
        result = result * 31 + (this.groupMemberAttributeName == null ? 0 : this.groupMemberAttributeName.hashCode());
        result = result * 31 + (this.maxPoolSize == null ? 0 : this.maxPoolSize.hashCode());
        result = result * 31 + (this.isFullDn == null ? 0 : this.isFullDn.hashCode());
        result = result * 31 + (this.userBaseDN == null ? 0 : this.userBaseDN.hashCode());
        result = result * 31 + (this.groupAttributeValue == null ? 0 : this.groupAttributeValue.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LdapConfiguration)) {
            return false;
        }
        LdapConfiguration rhs = (LdapConfiguration)other;
        return (this.allAttributeName == rhs.allAttributeName || this.allAttributeName != null && this.allAttributeName.equals(rhs.allAttributeName)) && (this.truststoreConfigType == rhs.truststoreConfigType || this.truststoreConfigType != null && this.truststoreConfigType.equals((Object)rhs.truststoreConfigType)) && (this.usernameAttributeName == rhs.usernameAttributeName || this.usernameAttributeName != null && this.usernameAttributeName.equals(rhs.usernameAttributeName)) && (this.authRolesMapping == rhs.authRolesMapping || this.authRolesMapping != null && this.authRolesMapping.equals(rhs.authRolesMapping)) && (this.groupAttributeName == rhs.groupAttributeName || this.groupAttributeName != null && this.groupAttributeName.equals(rhs.groupAttributeName)) && (this.groupBaseDN == rhs.groupBaseDN || this.groupBaseDN != null && this.groupBaseDN.equals(rhs.groupBaseDN)) && (this.port == rhs.port || this.port != null && this.port.equals(rhs.port)) && (this.roleAdminName == rhs.roleAdminName || this.roleAdminName != null && this.roleAdminName.equals(rhs.roleAdminName)) && (this.mailAttributeName == rhs.mailAttributeName || this.mailAttributeName != null && this.mailAttributeName.equals(rhs.mailAttributeName)) && (this.truststoreFormat == rhs.truststoreFormat || this.truststoreFormat != null && this.truststoreFormat.equals(rhs.truststoreFormat)) && (this.trustStoreConfig == rhs.trustStoreConfig || this.trustStoreConfig != null && this.trustStoreConfig.equals(rhs.trustStoreConfig)) && (this.dnAdminPassword == rhs.dnAdminPassword || this.dnAdminPassword != null && this.dnAdminPassword.equals(rhs.dnAdminPassword)) && (this.sslEnabled == rhs.sslEnabled || this.sslEnabled != null && this.sslEnabled.equals(rhs.sslEnabled)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.dnAdminPrincipal == rhs.dnAdminPrincipal || this.dnAdminPrincipal != null && this.dnAdminPrincipal.equals(rhs.dnAdminPrincipal)) && (this.authReassignRoles == rhs.authReassignRoles || this.authReassignRoles != null && this.authReassignRoles.equals(rhs.authReassignRoles)) && (this.groupMemberAttributeName == rhs.groupMemberAttributeName || this.groupMemberAttributeName != null && this.groupMemberAttributeName.equals(rhs.groupMemberAttributeName)) && (this.maxPoolSize == rhs.maxPoolSize || this.maxPoolSize != null && this.maxPoolSize.equals(rhs.maxPoolSize)) && (this.isFullDn == rhs.isFullDn || this.isFullDn != null && this.isFullDn.equals(rhs.isFullDn)) && (this.userBaseDN == rhs.userBaseDN || this.userBaseDN != null && this.userBaseDN.equals(rhs.userBaseDN)) && (this.groupAttributeValue == rhs.groupAttributeValue || this.groupAttributeValue != null && this.groupAttributeValue.equals(rhs.groupAttributeValue));
    }

    public static enum TruststoreConfigType {
        TRUST_ALL("TrustAll"),
        JVM_DEFAULT("JVMDefault"),
        HOST_NAME("HostName"),
        CUSTOM_TRUST_STORE("CustomTrustStore");

        private final String value;
        private static final Map<String, TruststoreConfigType> CONSTANTS;

        private TruststoreConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TruststoreConfigType fromValue(String value) {
            TruststoreConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TruststoreConfigType>();
            for (TruststoreConfigType c : TruststoreConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

