/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TokenType {
    REFRESH_TOKEN("REFRESH_TOKEN"),
    EMAIL_VERIFICATION("EMAIL_VERIFICATION"),
    PASSWORD_RESET("PASSWORD_RESET"),
    PERSONAL_ACCESS_TOKEN("PERSONAL_ACCESS_TOKEN");

    private final String value;
    private static final Map<String, TokenType> CONSTANTS;

    private TokenType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TokenType fromValue(String value) {
        TokenType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TokenType>();
        for (TokenType c : TokenType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

