/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"chartType", "total", "data"})
public class DataInsightChartResult {
    @JsonProperty(value="chartType")
    @JsonPropertyDescription(value="chart type. Must match `name` of a `dataInsightChartDefinition`.")
    @NotNull
    private DataInsightChartType chartType;
    @JsonProperty(value="total")
    @JsonPropertyDescription(value="Total number of hits returned by the aggregation.")
    private Integer total;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Array of consumable data.")
    @Valid
    private List<Object> data = new ArrayList<Object>();

    @JsonProperty(value="chartType")
    public DataInsightChartType getChartType() {
        return this.chartType;
    }

    @JsonProperty(value="chartType")
    public void setChartType(DataInsightChartType chartType) {
        this.chartType = chartType;
    }

    public DataInsightChartResult withChartType(DataInsightChartType chartType) {
        this.chartType = chartType;
        return this;
    }

    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public DataInsightChartResult withTotal(Integer total) {
        this.total = total;
        return this;
    }

    @JsonProperty(value="data")
    public List<Object> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(List<Object> data) {
        this.data = data;
    }

    public DataInsightChartResult withData(List<Object> data) {
        this.data = data;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataInsightChartResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("chartType");
        sb.append('=');
        sb.append(this.chartType == null ? "<null>" : this.chartType);
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(this.total == null ? "<null>" : this.total);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.chartType == null ? 0 : this.chartType.hashCode());
        result = result * 31 + (this.total == null ? 0 : this.total.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataInsightChartResult)) {
            return false;
        }
        DataInsightChartResult rhs = (DataInsightChartResult)other;
        return (this.chartType == rhs.chartType || this.chartType != null && this.chartType.equals((Object)rhs.chartType)) && (this.total == rhs.total || this.total != null && this.total.equals(rhs.total)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data));
    }

    public static enum DataInsightChartType {
        DAILY_ACTIVE_USERS("DailyActiveUsers"),
        MOST_ACTIVE_USERS("MostActiveUsers"),
        MOST_VIEWED_ENTITIES("MostViewedEntities"),
        PAGE_VIEWS_BY_ENTITIES("PageViewsByEntities"),
        UNUSED_ASSETS("UnusedAssets"),
        AGGREGATED_UNUSED_ASSETS_SIZE("AggregatedUnusedAssetsSize"),
        AGGREGATED_UNUSED_ASSETS_COUNT("AggregatedUnusedAssetsCount"),
        AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE("AggregatedUsedVsUnusedAssetsSize"),
        AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT("AggregatedUsedVsUnusedAssetsCount");

        private final String value;
        private static final Map<String, DataInsightChartType> CONSTANTS;

        private DataInsightChartType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataInsightChartType fromValue(String value) {
            DataInsightChartType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DataInsightChartType>();
            for (DataInsightChartType c : DataInsightChartType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

