/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Function {
    COUNT("count"),
    SUM("sum"),
    AVG("avg"),
    MIN("min"),
    MAX("max"),
    UNIQUE("unique");

    private final String value;
    private static final Map<String, Function> CONSTANTS;

    private Function(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Function fromValue(String value) {
        Function constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Function>();
        for (Function c : Function.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

