/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.dataInsight.custom.Function;
import org.openmetadata.schema.dataInsight.custom.KPIDetails;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "function", "field", "filter", "treeFilter", "formula", "groupBy", "includeGroups", "excludeGroups", "xAxisLabel", "yAxisLabel", "kpiDetails"})
public class LineChart {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of the data insight chart.")
    private Type type = Type.fromValue("LineChart");
    @JsonProperty(value="function")
    @JsonPropertyDescription(value="aggregation function for chart")
    private Function function;
    @JsonProperty(value="field")
    @JsonPropertyDescription(value="Filter field for the data insight chart.")
    private String field;
    @JsonProperty(value="filter")
    @JsonPropertyDescription(value="Filter value for the data insight chart.")
    private String filter;
    @JsonProperty(value="treeFilter")
    @JsonPropertyDescription(value="Tree filter value for the data insight chart. Needed for UI to recreate advance filter tree.")
    private String treeFilter;
    @JsonProperty(value="formula")
    @JsonPropertyDescription(value="Formula for the data insight chart calculation.")
    private String formula;
    @JsonProperty(value="groupBy")
    @JsonPropertyDescription(value="Breakdown field for the data insight chart.")
    private String groupBy;
    @JsonProperty(value="includeGroups")
    @JsonPropertyDescription(value="List of groups to be included in the data insight chart when groupBy is specified.")
    @Valid
    private List<String> includeGroups = new ArrayList<String>();
    @JsonProperty(value="excludeGroups")
    @JsonPropertyDescription(value="List of groups to be excluded in the data insight chart when groupBy is specified.")
    @Valid
    private List<String> excludeGroups = new ArrayList<String>();
    @JsonProperty(value="xAxisLabel")
    @JsonPropertyDescription(value="X-axis label for the data insight chart.")
    private String xAxisLabel;
    @JsonProperty(value="yAxisLabel")
    @JsonPropertyDescription(value="Y-axis label for the data insight chart.")
    private String yAxisLabel;
    @JsonProperty(value="kpiDetails")
    @JsonPropertyDescription(value="KPI details for the data insight chart.")
    @Valid
    private KPIDetails kpiDetails;

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public LineChart withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="function")
    public Function getFunction() {
        return this.function;
    }

    @JsonProperty(value="function")
    public void setFunction(Function function) {
        this.function = function;
    }

    public LineChart withFunction(Function function) {
        this.function = function;
        return this;
    }

    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    public void setField(String field) {
        this.field = field;
    }

    public LineChart withField(String field) {
        this.field = field;
        return this;
    }

    @JsonProperty(value="filter")
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public LineChart withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty(value="treeFilter")
    public String getTreeFilter() {
        return this.treeFilter;
    }

    @JsonProperty(value="treeFilter")
    public void setTreeFilter(String treeFilter) {
        this.treeFilter = treeFilter;
    }

    public LineChart withTreeFilter(String treeFilter) {
        this.treeFilter = treeFilter;
        return this;
    }

    @JsonProperty(value="formula")
    public String getFormula() {
        return this.formula;
    }

    @JsonProperty(value="formula")
    public void setFormula(String formula) {
        this.formula = formula;
    }

    public LineChart withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    @JsonProperty(value="groupBy")
    public String getGroupBy() {
        return this.groupBy;
    }

    @JsonProperty(value="groupBy")
    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public LineChart withGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @JsonProperty(value="includeGroups")
    public List<String> getIncludeGroups() {
        return this.includeGroups;
    }

    @JsonProperty(value="includeGroups")
    public void setIncludeGroups(List<String> includeGroups) {
        this.includeGroups = includeGroups;
    }

    public LineChart withIncludeGroups(List<String> includeGroups) {
        this.includeGroups = includeGroups;
        return this;
    }

    @JsonProperty(value="excludeGroups")
    public List<String> getExcludeGroups() {
        return this.excludeGroups;
    }

    @JsonProperty(value="excludeGroups")
    public void setExcludeGroups(List<String> excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public LineChart withExcludeGroups(List<String> excludeGroups) {
        this.excludeGroups = excludeGroups;
        return this;
    }

    @JsonProperty(value="xAxisLabel")
    public String getxAxisLabel() {
        return this.xAxisLabel;
    }

    @JsonProperty(value="xAxisLabel")
    public void setxAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public LineChart withxAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @JsonProperty(value="yAxisLabel")
    public String getyAxisLabel() {
        return this.yAxisLabel;
    }

    @JsonProperty(value="yAxisLabel")
    public void setyAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public LineChart withyAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @JsonProperty(value="kpiDetails")
    public KPIDetails getKpiDetails() {
        return this.kpiDetails;
    }

    @JsonProperty(value="kpiDetails")
    public void setKpiDetails(KPIDetails kpiDetails) {
        this.kpiDetails = kpiDetails;
    }

    public LineChart withKpiDetails(KPIDetails kpiDetails) {
        this.kpiDetails = kpiDetails;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LineChart.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("function");
        sb.append('=');
        sb.append(this.function == null ? "<null>" : this.function);
        sb.append(',');
        sb.append("field");
        sb.append('=');
        sb.append(this.field == null ? "<null>" : this.field);
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(this.filter == null ? "<null>" : this.filter);
        sb.append(',');
        sb.append("treeFilter");
        sb.append('=');
        sb.append(this.treeFilter == null ? "<null>" : this.treeFilter);
        sb.append(',');
        sb.append("formula");
        sb.append('=');
        sb.append(this.formula == null ? "<null>" : this.formula);
        sb.append(',');
        sb.append("groupBy");
        sb.append('=');
        sb.append(this.groupBy == null ? "<null>" : this.groupBy);
        sb.append(',');
        sb.append("includeGroups");
        sb.append('=');
        sb.append(this.includeGroups == null ? "<null>" : this.includeGroups);
        sb.append(',');
        sb.append("excludeGroups");
        sb.append('=');
        sb.append(this.excludeGroups == null ? "<null>" : this.excludeGroups);
        sb.append(',');
        sb.append("xAxisLabel");
        sb.append('=');
        sb.append(this.xAxisLabel == null ? "<null>" : this.xAxisLabel);
        sb.append(',');
        sb.append("yAxisLabel");
        sb.append('=');
        sb.append(this.yAxisLabel == null ? "<null>" : this.yAxisLabel);
        sb.append(',');
        sb.append("kpiDetails");
        sb.append('=');
        sb.append(this.kpiDetails == null ? "<null>" : this.kpiDetails);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.groupBy == null ? 0 : this.groupBy.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.treeFilter == null ? 0 : this.treeFilter.hashCode());
        result = result * 31 + (this.includeGroups == null ? 0 : this.includeGroups.hashCode());
        result = result * 31 + (this.filter == null ? 0 : this.filter.hashCode());
        result = result * 31 + (this.yAxisLabel == null ? 0 : this.yAxisLabel.hashCode());
        result = result * 31 + (this.kpiDetails == null ? 0 : this.kpiDetails.hashCode());
        result = result * 31 + (this.field == null ? 0 : this.field.hashCode());
        result = result * 31 + (this.excludeGroups == null ? 0 : this.excludeGroups.hashCode());
        result = result * 31 + (this.function == null ? 0 : this.function.hashCode());
        result = result * 31 + (this.formula == null ? 0 : this.formula.hashCode());
        result = result * 31 + (this.xAxisLabel == null ? 0 : this.xAxisLabel.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LineChart)) {
            return false;
        }
        LineChart rhs = (LineChart)other;
        return (this.groupBy == rhs.groupBy || this.groupBy != null && this.groupBy.equals(rhs.groupBy)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.treeFilter == rhs.treeFilter || this.treeFilter != null && this.treeFilter.equals(rhs.treeFilter)) && (this.includeGroups == rhs.includeGroups || this.includeGroups != null && this.includeGroups.equals(rhs.includeGroups)) && (this.filter == rhs.filter || this.filter != null && this.filter.equals(rhs.filter)) && (this.yAxisLabel == rhs.yAxisLabel || this.yAxisLabel != null && this.yAxisLabel.equals(rhs.yAxisLabel)) && (this.kpiDetails == rhs.kpiDetails || this.kpiDetails != null && this.kpiDetails.equals(rhs.kpiDetails)) && (this.field == rhs.field || this.field != null && this.field.equals(rhs.field)) && (this.excludeGroups == rhs.excludeGroups || this.excludeGroups != null && this.excludeGroups.equals(rhs.excludeGroups)) && (this.function == rhs.function || this.function != null && this.function.equals((Object)rhs.function)) && (this.formula == rhs.formula || this.formula != null && this.formula.equals(rhs.formula)) && (this.xAxisLabel == rhs.xAxisLabel || this.xAxisLabel != null && this.xAxisLabel.equals(rhs.xAxisLabel));
    }

    public static enum Type {
        LINE_CHART("LineChart");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

