/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.dataInsight.custom.Function;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "function", "field", "filter", "treeFilter", "formula"})
public class SummaryCard {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of the data insight chart.")
    private Type type = Type.fromValue("SummaryCard");
    @JsonProperty(value="function")
    @JsonPropertyDescription(value="aggregation function for chart")
    private Function function;
    @JsonProperty(value="field")
    @JsonPropertyDescription(value="Filter field for the data insight chart.")
    private String field;
    @JsonProperty(value="filter")
    @JsonPropertyDescription(value="Filter value for the data insight chart.")
    private String filter;
    @JsonProperty(value="treeFilter")
    @JsonPropertyDescription(value="Tree filter value for the data insight chart. Needed for UI to recreate advance filter tree.")
    private String treeFilter;
    @JsonProperty(value="formula")
    @JsonPropertyDescription(value="Formula for the data insight chart calculation.")
    private String formula;

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public SummaryCard withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="function")
    public Function getFunction() {
        return this.function;
    }

    @JsonProperty(value="function")
    public void setFunction(Function function) {
        this.function = function;
    }

    public SummaryCard withFunction(Function function) {
        this.function = function;
        return this;
    }

    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    public void setField(String field) {
        this.field = field;
    }

    public SummaryCard withField(String field) {
        this.field = field;
        return this;
    }

    @JsonProperty(value="filter")
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public SummaryCard withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty(value="treeFilter")
    public String getTreeFilter() {
        return this.treeFilter;
    }

    @JsonProperty(value="treeFilter")
    public void setTreeFilter(String treeFilter) {
        this.treeFilter = treeFilter;
    }

    public SummaryCard withTreeFilter(String treeFilter) {
        this.treeFilter = treeFilter;
        return this;
    }

    @JsonProperty(value="formula")
    public String getFormula() {
        return this.formula;
    }

    @JsonProperty(value="formula")
    public void setFormula(String formula) {
        this.formula = formula;
    }

    public SummaryCard withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SummaryCard.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("function");
        sb.append('=');
        sb.append(this.function == null ? "<null>" : this.function);
        sb.append(',');
        sb.append("field");
        sb.append('=');
        sb.append(this.field == null ? "<null>" : this.field);
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(this.filter == null ? "<null>" : this.filter);
        sb.append(',');
        sb.append("treeFilter");
        sb.append('=');
        sb.append(this.treeFilter == null ? "<null>" : this.treeFilter);
        sb.append(',');
        sb.append("formula");
        sb.append('=');
        sb.append(this.formula == null ? "<null>" : this.formula);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.filter == null ? 0 : this.filter.hashCode());
        result = result * 31 + (this.field == null ? 0 : this.field.hashCode());
        result = result * 31 + (this.function == null ? 0 : this.function.hashCode());
        result = result * 31 + (this.formula == null ? 0 : this.formula.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.treeFilter == null ? 0 : this.treeFilter.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SummaryCard)) {
            return false;
        }
        SummaryCard rhs = (SummaryCard)other;
        return (this.filter == rhs.filter || this.filter != null && this.filter.equals(rhs.filter)) && (this.field == rhs.field || this.field != null && this.field.equals(rhs.field)) && (this.function == rhs.function || this.function != null && this.function.equals((Object)rhs.function)) && (this.formula == rhs.formula || this.formula != null && this.formula.equals(rhs.formula)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.treeFilter == rhs.treeFilter || this.treeFilter != null && this.treeFilter.equals(rhs.treeFilter));
    }

    public static enum Type {
        SUMMARY_CARD("SummaryCard");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

