/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entity", "sizeInBytes", "lastAccessedAt"})
public class UnusedAssets {
    @JsonProperty(value="entity")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference entity;
    @JsonProperty(value="sizeInBytes")
    @JsonPropertyDescription(value="Size of the asset in bytes")
    private Double sizeInBytes;
    @JsonProperty(value="lastAccessedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long lastAccessedAt;

    @JsonProperty(value="entity")
    public EntityReference getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    public void setEntity(EntityReference entity) {
        this.entity = entity;
    }

    public UnusedAssets withEntity(EntityReference entity) {
        this.entity = entity;
        return this;
    }

    @JsonProperty(value="sizeInBytes")
    public Double getSizeInBytes() {
        return this.sizeInBytes;
    }

    @JsonProperty(value="sizeInBytes")
    public void setSizeInBytes(Double sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public UnusedAssets withSizeInBytes(Double sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    @JsonProperty(value="lastAccessedAt")
    public Long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    @JsonProperty(value="lastAccessedAt")
    public void setLastAccessedAt(Long lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
    }

    public UnusedAssets withLastAccessedAt(Long lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UnusedAssets.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entity");
        sb.append('=');
        sb.append(this.entity == null ? "<null>" : this.entity);
        sb.append(',');
        sb.append("sizeInBytes");
        sb.append('=');
        sb.append(this.sizeInBytes == null ? "<null>" : this.sizeInBytes);
        sb.append(',');
        sb.append("lastAccessedAt");
        sb.append('=');
        sb.append(this.lastAccessedAt == null ? "<null>" : this.lastAccessedAt);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastAccessedAt == null ? 0 : this.lastAccessedAt.hashCode());
        result = result * 31 + (this.sizeInBytes == null ? 0 : this.sizeInBytes.hashCode());
        result = result * 31 + (this.entity == null ? 0 : this.entity.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UnusedAssets)) {
            return false;
        }
        UnusedAssets rhs = (UnusedAssets)other;
        return (this.lastAccessedAt == rhs.lastAccessedAt || this.lastAccessedAt != null && this.lastAccessedAt.equals(rhs.lastAccessedAt)) && (this.sizeInBytes == rhs.sizeInBytes || this.sizeInBytes != null && this.sizeInBytes.equals(rhs.sizeInBytes)) && (this.entity == rhs.entity || this.entity != null && this.entity.equals(rhs.entity));
    }
}

