/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.email;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.email.EmailTemplatePlaceholder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"template", "placeHolders"})
public class EmailTemplate {
    @JsonProperty(value="template")
    @JsonPropertyDescription(value="Template data.")
    @NotNull
    private String template;
    @JsonProperty(value="placeHolders")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of placeholders.")
    @Valid
    @NotNull
    private Set<EmailTemplatePlaceholder> placeHolders = new LinkedHashSet<EmailTemplatePlaceholder>();

    @JsonProperty(value="template")
    public String getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    public void setTemplate(String template) {
        this.template = template;
    }

    public EmailTemplate withTemplate(String template) {
        this.template = template;
        return this;
    }

    @JsonProperty(value="placeHolders")
    public Set<EmailTemplatePlaceholder> getPlaceHolders() {
        return this.placeHolders;
    }

    @JsonProperty(value="placeHolders")
    public void setPlaceHolders(Set<EmailTemplatePlaceholder> placeHolders) {
        this.placeHolders = placeHolders;
    }

    public EmailTemplate withPlaceHolders(Set<EmailTemplatePlaceholder> placeHolders) {
        this.placeHolders = placeHolders;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EmailTemplate.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("template");
        sb.append('=');
        sb.append(this.template == null ? "<null>" : this.template);
        sb.append(',');
        sb.append("placeHolders");
        sb.append('=');
        sb.append(this.placeHolders == null ? "<null>" : this.placeHolders);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.template == null ? 0 : this.template.hashCode());
        result = result * 31 + (this.placeHolders == null ? 0 : this.placeHolders.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EmailTemplate)) {
            return false;
        }
        EmailTemplate rhs = (EmailTemplate)other;
        return (this.template == rhs.template || this.template != null && this.template.equals(rhs.template)) && (this.placeHolders == rhs.placeHolders || this.placeHolders != null && this.placeHolders.equals(rhs.placeHolders));
    }
}

