/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"appId", "appName", "timestamp", "extension"})
public class AppExtension {
    @JsonProperty(value="appId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID appId;
    @JsonProperty(value="appName")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String appName;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Extension type.")
    @NotNull
    private ExtensionType extension;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="appId")
    public UUID getAppId() {
        return this.appId;
    }

    @JsonProperty(value="appId")
    public void setAppId(UUID appId) {
        this.appId = appId;
    }

    public AppExtension withAppId(UUID appId) {
        this.appId = appId;
        return this;
    }

    @JsonProperty(value="appName")
    public String getAppName() {
        return this.appName;
    }

    @JsonProperty(value="appName")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    public AppExtension withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AppExtension withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="extension")
    public ExtensionType getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public AppExtension withExtension(ExtensionType extension) {
        this.extension = extension;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AppExtension withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AppExtension.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("appId");
        sb.append('=');
        sb.append(this.appId == null ? "<null>" : this.appId);
        sb.append(',');
        sb.append("appName");
        sb.append('=');
        sb.append(this.appName == null ? "<null>" : this.appName);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.appName == null ? 0 : this.appName.hashCode());
        result = result * 31 + (this.appId == null ? 0 : this.appId.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AppExtension)) {
            return false;
        }
        AppExtension rhs = (AppExtension)other;
        return (this.extension == rhs.extension || this.extension != null && this.extension.equals((Object)rhs.extension)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.appName == rhs.appName || this.appName != null && this.appName.equals(rhs.appName)) && (this.appId == rhs.appId || this.appId != null && this.appId.equals(rhs.appId)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }

    public static enum ExtensionType {
        STATUS("status"),
        LIMITS("limits"),
        CUSTOM("custom");

        private final String value;
        private static final Map<String, ExtensionType> CONSTANTS;

        private ExtensionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExtensionType fromValue(String value) {
            ExtensionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ExtensionType>();
            for (ExtensionType c : ExtensionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

