/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.entity.app.AppSchedule;
import org.openmetadata.schema.entity.app.FailureContext;
import org.openmetadata.schema.entity.app.SuccessContext;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"appId", "appName", "timestamp", "extension", "status", "runType", "startTime", "endTime", "executionTime", "failureContext", "successContext", "scheduleInfo"})
public class AppRunRecord {
    @JsonProperty(value="appId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID appId;
    @JsonProperty(value="appName")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) String appName;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Extension type.")
    private String extension = "status";
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status for the Job.")
    private Status status;
    @JsonProperty(value="runType")
    @JsonPropertyDescription(value="This schema defines the type of application Run.")
    private String runType;
    @JsonProperty(value="startTime")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long startTime;
    @JsonProperty(value="endTime")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long endTime;
    @JsonProperty(value="executionTime")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long executionTime;
    @JsonProperty(value="failureContext")
    @JsonPropertyDescription(value="Failure Context for the Application.")
    @Valid
    private FailureContext failureContext;
    @JsonProperty(value="successContext")
    @JsonPropertyDescription(value="Success Context for the Application.")
    @Valid
    private SuccessContext successContext;
    @JsonProperty(value="scheduleInfo")
    @JsonPropertyDescription(value="This schema defines the type of application.")
    private AppSchedule scheduleInfo;

    @JsonProperty(value="appId")
    public UUID getAppId() {
        return this.appId;
    }

    @JsonProperty(value="appId")
    public void setAppId(UUID appId) {
        this.appId = appId;
    }

    public AppRunRecord withAppId(UUID appId) {
        this.appId = appId;
        return this;
    }

    @JsonProperty(value="appName")
    public String getAppName() {
        return this.appName;
    }

    @JsonProperty(value="appName")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    public AppRunRecord withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AppRunRecord withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="extension")
    public String getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public AppRunRecord withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public AppRunRecord withStatus(Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="runType")
    public String getRunType() {
        return this.runType;
    }

    @JsonProperty(value="runType")
    public void setRunType(String runType) {
        this.runType = runType;
    }

    public AppRunRecord withRunType(String runType) {
        this.runType = runType;
        return this;
    }

    @JsonProperty(value="startTime")
    public Long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public AppRunRecord withStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty(value="endTime")
    public Long getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public AppRunRecord withEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="executionTime")
    public Long getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty(value="executionTime")
    public void setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
    }

    public AppRunRecord withExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    @JsonProperty(value="failureContext")
    public FailureContext getFailureContext() {
        return this.failureContext;
    }

    @JsonProperty(value="failureContext")
    public void setFailureContext(FailureContext failureContext) {
        this.failureContext = failureContext;
    }

    public AppRunRecord withFailureContext(FailureContext failureContext) {
        this.failureContext = failureContext;
        return this;
    }

    @JsonProperty(value="successContext")
    public SuccessContext getSuccessContext() {
        return this.successContext;
    }

    @JsonProperty(value="successContext")
    public void setSuccessContext(SuccessContext successContext) {
        this.successContext = successContext;
    }

    public AppRunRecord withSuccessContext(SuccessContext successContext) {
        this.successContext = successContext;
        return this;
    }

    @JsonProperty(value="scheduleInfo")
    public AppSchedule getScheduleInfo() {
        return this.scheduleInfo;
    }

    @JsonProperty(value="scheduleInfo")
    public void setScheduleInfo(AppSchedule scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    public AppRunRecord withScheduleInfo(AppSchedule scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AppRunRecord.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("appId");
        sb.append('=');
        sb.append(this.appId == null ? "<null>" : this.appId);
        sb.append(',');
        sb.append("appName");
        sb.append('=');
        sb.append(this.appName == null ? "<null>" : this.appName);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("runType");
        sb.append('=');
        sb.append(this.runType == null ? "<null>" : this.runType);
        sb.append(',');
        sb.append("startTime");
        sb.append('=');
        sb.append(this.startTime == null ? "<null>" : this.startTime);
        sb.append(',');
        sb.append("endTime");
        sb.append('=');
        sb.append(this.endTime == null ? "<null>" : this.endTime);
        sb.append(',');
        sb.append("executionTime");
        sb.append('=');
        sb.append(this.executionTime == null ? "<null>" : this.executionTime);
        sb.append(',');
        sb.append("failureContext");
        sb.append('=');
        sb.append(this.failureContext == null ? "<null>" : this.failureContext);
        sb.append(',');
        sb.append("successContext");
        sb.append('=');
        sb.append(this.successContext == null ? "<null>" : this.successContext);
        sb.append(',');
        sb.append("scheduleInfo");
        sb.append('=');
        sb.append(this.scheduleInfo == null ? "<null>" : this.scheduleInfo);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.scheduleInfo == null ? 0 : this.scheduleInfo.hashCode());
        result = result * 31 + (this.appName == null ? 0 : this.appName.hashCode());
        result = result * 31 + (this.runType == null ? 0 : this.runType.hashCode());
        result = result * 31 + (this.failureContext == null ? 0 : this.failureContext.hashCode());
        result = result * 31 + (this.executionTime == null ? 0 : this.executionTime.hashCode());
        result = result * 31 + (this.appId == null ? 0 : this.appId.hashCode());
        result = result * 31 + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = result * 31 + (this.successContext == null ? 0 : this.successContext.hashCode());
        result = result * 31 + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AppRunRecord)) {
            return false;
        }
        AppRunRecord rhs = (AppRunRecord)other;
        return (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.scheduleInfo == rhs.scheduleInfo || this.scheduleInfo != null && this.scheduleInfo.equals(rhs.scheduleInfo)) && (this.appName == rhs.appName || this.appName != null && this.appName.equals(rhs.appName)) && (this.runType == rhs.runType || this.runType != null && this.runType.equals(rhs.runType)) && (this.failureContext == rhs.failureContext || this.failureContext != null && this.failureContext.equals(rhs.failureContext)) && (this.executionTime == rhs.executionTime || this.executionTime != null && this.executionTime.equals(rhs.executionTime)) && (this.appId == rhs.appId || this.appId != null && this.appId.equals(rhs.appId)) && (this.startTime == rhs.startTime || this.startTime != null && this.startTime.equals(rhs.startTime)) && (this.successContext == rhs.successContext || this.successContext != null && this.successContext.equals(rhs.successContext)) && (this.endTime == rhs.endTime || this.endTime != null && this.endTime.equals(rhs.endTime)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Status {
        STARTED("started"),
        RUNNING("running"),
        COMPLETED("completed"),
        FAILED("failed"),
        ACTIVE("active"),
        ACTIVE_ERROR("activeError"),
        STOPPED("stopped"),
        SUCCESS("success");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

