/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.app.AppSchedule;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owners", "bot", "appConfiguration", "appSchedule", "domain"})
public class CreateApp
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name for the application.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="bot")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String bot;
    @JsonProperty(value="appConfiguration")
    @JsonPropertyDescription(value="Application Configuration object.")
    private Object appConfiguration;
    @JsonProperty(value="appSchedule")
    @JsonPropertyDescription(value="This schema defines the type of application.")
    private AppSchedule appSchedule;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateApp withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateApp withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateApp withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateApp withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="bot")
    public String getBot() {
        return this.bot;
    }

    @JsonProperty(value="bot")
    public void setBot(String bot) {
        this.bot = bot;
    }

    public CreateApp withBot(String bot) {
        this.bot = bot;
        return this;
    }

    @JsonProperty(value="appConfiguration")
    public Object getAppConfiguration() {
        return this.appConfiguration;
    }

    @JsonProperty(value="appConfiguration")
    public void setAppConfiguration(Object appConfiguration) {
        this.appConfiguration = appConfiguration;
    }

    public CreateApp withAppConfiguration(Object appConfiguration) {
        this.appConfiguration = appConfiguration;
        return this;
    }

    @JsonProperty(value="appSchedule")
    public AppSchedule getAppSchedule() {
        return this.appSchedule;
    }

    @JsonProperty(value="appSchedule")
    public void setAppSchedule(AppSchedule appSchedule) {
        this.appSchedule = appSchedule;
    }

    public CreateApp withAppSchedule(AppSchedule appSchedule) {
        this.appSchedule = appSchedule;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateApp withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateApp.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("bot");
        sb.append('=');
        sb.append(this.bot == null ? "<null>" : this.bot);
        sb.append(',');
        sb.append("appConfiguration");
        sb.append('=');
        sb.append(this.appConfiguration == null ? "<null>" : this.appConfiguration);
        sb.append(',');
        sb.append("appSchedule");
        sb.append('=');
        sb.append(this.appSchedule == null ? "<null>" : this.appSchedule);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.appSchedule == null ? 0 : this.appSchedule.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.bot == null ? 0 : this.bot.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.appConfiguration == null ? 0 : this.appConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateApp)) {
            return false;
        }
        CreateApp rhs = (CreateApp)other;
        return (this.appSchedule == rhs.appSchedule || this.appSchedule != null && this.appSchedule.equals(rhs.appSchedule)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.bot == rhs.bot || this.bot != null && this.bot.equals(rhs.bot)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.appConfiguration == rhs.appConfiguration || this.appConfiguration != null && this.appConfiguration.equals(rhs.appConfiguration));
    }
}

