/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.schema.entity.app.NativeAppPermission;
import org.openmetadata.schema.entity.app.ScheduleType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "features", "owners", "tags", "developer", "developerUrl", "privacyPolicyUrl", "supportEmail", "className", "sourcePythonClass", "appType", "scheduleType", "permission", "runtime", "allowConfiguration", "appConfiguration", "appLogoUrl", "appScreenshots", "system", "domain"})
public class CreateAppMarketPlaceDefinitionReq
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name for the application.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="features")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String features;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags associated with the entity.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="developer")
    @JsonPropertyDescription(value="Developer For the Application.")
    private String developer;
    @JsonProperty(value="developerUrl")
    @JsonPropertyDescription(value="Url for the developer")
    private String developerUrl;
    @JsonProperty(value="privacyPolicyUrl")
    @JsonPropertyDescription(value="Privacy Policy for the developer")
    private String privacyPolicyUrl;
    @JsonProperty(value="supportEmail")
    @JsonPropertyDescription(value="Support Email for the application")
    private String supportEmail;
    @JsonProperty(value="className")
    @JsonPropertyDescription(value="Full Qualified ClassName for the the application")
    @NotNull
    private String className;
    @JsonProperty(value="sourcePythonClass")
    @JsonPropertyDescription(value="Fully Qualified class name for the Python source that will execute the external application.")
    private String sourcePythonClass;
    @JsonProperty(value="appType")
    @JsonPropertyDescription(value="This schema defines the type of application.")
    @NotNull
    private AppType appType;
    @JsonProperty(value="scheduleType")
    @JsonPropertyDescription(value="This schema defines the type of application.")
    @NotNull
    private ScheduleType scheduleType;
    @JsonProperty(value="permission")
    @JsonPropertyDescription(value="This schema defines the Permission used by Native Application.")
    @NotNull
    private NativeAppPermission permission;
    @JsonProperty(value="runtime")
    @JsonPropertyDescription(value="Execution Configuration.")
    private Object runtime;
    @JsonProperty(value="allowConfiguration")
    @JsonPropertyDescription(value="Allow users to configure the app from the UI. If `false`, the `configure` step will be hidden.")
    private Boolean allowConfiguration = true;
    @JsonProperty(value="appConfiguration")
    private Object appConfiguration;
    @JsonProperty(value="appLogoUrl")
    @JsonPropertyDescription(value="Application Logo Url.")
    private URI appLogoUrl;
    @JsonProperty(value="appScreenshots")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="Application Screenshots.")
    @Valid
    private Set<String> appScreenshots = new LinkedHashSet<String>();
    @JsonProperty(value="system")
    @JsonPropertyDescription(value="A system app cannot be uninstalled or modified.")
    private Boolean system = false;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateAppMarketPlaceDefinitionReq withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateAppMarketPlaceDefinitionReq withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAppMarketPlaceDefinitionReq withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="features")
    public String getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    public void setFeatures(String features) {
        this.features = features;
    }

    public CreateAppMarketPlaceDefinitionReq withFeatures(String features) {
        this.features = features;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateAppMarketPlaceDefinitionReq withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateAppMarketPlaceDefinitionReq withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="developer")
    public String getDeveloper() {
        return this.developer;
    }

    @JsonProperty(value="developer")
    public void setDeveloper(String developer) {
        this.developer = developer;
    }

    public CreateAppMarketPlaceDefinitionReq withDeveloper(String developer) {
        this.developer = developer;
        return this;
    }

    @JsonProperty(value="developerUrl")
    public String getDeveloperUrl() {
        return this.developerUrl;
    }

    @JsonProperty(value="developerUrl")
    public void setDeveloperUrl(String developerUrl) {
        this.developerUrl = developerUrl;
    }

    public CreateAppMarketPlaceDefinitionReq withDeveloperUrl(String developerUrl) {
        this.developerUrl = developerUrl;
        return this;
    }

    @JsonProperty(value="privacyPolicyUrl")
    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    @JsonProperty(value="privacyPolicyUrl")
    public void setPrivacyPolicyUrl(String privacyPolicyUrl) {
        this.privacyPolicyUrl = privacyPolicyUrl;
    }

    public CreateAppMarketPlaceDefinitionReq withPrivacyPolicyUrl(String privacyPolicyUrl) {
        this.privacyPolicyUrl = privacyPolicyUrl;
        return this;
    }

    @JsonProperty(value="supportEmail")
    public String getSupportEmail() {
        return this.supportEmail;
    }

    @JsonProperty(value="supportEmail")
    public void setSupportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
    }

    public CreateAppMarketPlaceDefinitionReq withSupportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
        return this;
    }

    @JsonProperty(value="className")
    public String getClassName() {
        return this.className;
    }

    @JsonProperty(value="className")
    public void setClassName(String className) {
        this.className = className;
    }

    public CreateAppMarketPlaceDefinitionReq withClassName(String className) {
        this.className = className;
        return this;
    }

    @JsonProperty(value="sourcePythonClass")
    public String getSourcePythonClass() {
        return this.sourcePythonClass;
    }

    @JsonProperty(value="sourcePythonClass")
    public void setSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
    }

    public CreateAppMarketPlaceDefinitionReq withSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
        return this;
    }

    @JsonProperty(value="appType")
    public AppType getAppType() {
        return this.appType;
    }

    @JsonProperty(value="appType")
    public void setAppType(AppType appType) {
        this.appType = appType;
    }

    public CreateAppMarketPlaceDefinitionReq withAppType(AppType appType) {
        this.appType = appType;
        return this;
    }

    @JsonProperty(value="scheduleType")
    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    @JsonProperty(value="scheduleType")
    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public CreateAppMarketPlaceDefinitionReq withScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    @JsonProperty(value="permission")
    public NativeAppPermission getPermission() {
        return this.permission;
    }

    @JsonProperty(value="permission")
    public void setPermission(NativeAppPermission permission) {
        this.permission = permission;
    }

    public CreateAppMarketPlaceDefinitionReq withPermission(NativeAppPermission permission) {
        this.permission = permission;
        return this;
    }

    @JsonProperty(value="runtime")
    public Object getRuntime() {
        return this.runtime;
    }

    @JsonProperty(value="runtime")
    public void setRuntime(Object runtime) {
        this.runtime = runtime;
    }

    public CreateAppMarketPlaceDefinitionReq withRuntime(Object runtime) {
        this.runtime = runtime;
        return this;
    }

    @JsonProperty(value="allowConfiguration")
    public Boolean getAllowConfiguration() {
        return this.allowConfiguration;
    }

    @JsonProperty(value="allowConfiguration")
    public void setAllowConfiguration(Boolean allowConfiguration) {
        this.allowConfiguration = allowConfiguration;
    }

    public CreateAppMarketPlaceDefinitionReq withAllowConfiguration(Boolean allowConfiguration) {
        this.allowConfiguration = allowConfiguration;
        return this;
    }

    @JsonProperty(value="appConfiguration")
    public Object getAppConfiguration() {
        return this.appConfiguration;
    }

    @JsonProperty(value="appConfiguration")
    public void setAppConfiguration(Object appConfiguration) {
        this.appConfiguration = appConfiguration;
    }

    public CreateAppMarketPlaceDefinitionReq withAppConfiguration(Object appConfiguration) {
        this.appConfiguration = appConfiguration;
        return this;
    }

    @JsonProperty(value="appLogoUrl")
    public URI getAppLogoUrl() {
        return this.appLogoUrl;
    }

    @JsonProperty(value="appLogoUrl")
    public void setAppLogoUrl(URI appLogoUrl) {
        this.appLogoUrl = appLogoUrl;
    }

    public CreateAppMarketPlaceDefinitionReq withAppLogoUrl(URI appLogoUrl) {
        this.appLogoUrl = appLogoUrl;
        return this;
    }

    @JsonProperty(value="appScreenshots")
    public Set<String> getAppScreenshots() {
        return this.appScreenshots;
    }

    @JsonProperty(value="appScreenshots")
    public void setAppScreenshots(Set<String> appScreenshots) {
        this.appScreenshots = appScreenshots;
    }

    public CreateAppMarketPlaceDefinitionReq withAppScreenshots(Set<String> appScreenshots) {
        this.appScreenshots = appScreenshots;
        return this;
    }

    @JsonProperty(value="system")
    public Boolean getSystem() {
        return this.system;
    }

    @JsonProperty(value="system")
    public void setSystem(Boolean system) {
        this.system = system;
    }

    public CreateAppMarketPlaceDefinitionReq withSystem(Boolean system) {
        this.system = system;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateAppMarketPlaceDefinitionReq withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateAppMarketPlaceDefinitionReq.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("features");
        sb.append('=');
        sb.append(this.features == null ? "<null>" : this.features);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("developer");
        sb.append('=');
        sb.append(this.developer == null ? "<null>" : this.developer);
        sb.append(',');
        sb.append("developerUrl");
        sb.append('=');
        sb.append(this.developerUrl == null ? "<null>" : this.developerUrl);
        sb.append(',');
        sb.append("privacyPolicyUrl");
        sb.append('=');
        sb.append(this.privacyPolicyUrl == null ? "<null>" : this.privacyPolicyUrl);
        sb.append(',');
        sb.append("supportEmail");
        sb.append('=');
        sb.append(this.supportEmail == null ? "<null>" : this.supportEmail);
        sb.append(',');
        sb.append("className");
        sb.append('=');
        sb.append(this.className == null ? "<null>" : this.className);
        sb.append(',');
        sb.append("sourcePythonClass");
        sb.append('=');
        sb.append(this.sourcePythonClass == null ? "<null>" : this.sourcePythonClass);
        sb.append(',');
        sb.append("appType");
        sb.append('=');
        sb.append(this.appType == null ? "<null>" : this.appType);
        sb.append(',');
        sb.append("scheduleType");
        sb.append('=');
        sb.append(this.scheduleType == null ? "<null>" : this.scheduleType);
        sb.append(',');
        sb.append("permission");
        sb.append('=');
        sb.append(this.permission == null ? "<null>" : this.permission);
        sb.append(',');
        sb.append("runtime");
        sb.append('=');
        sb.append(this.runtime == null ? "<null>" : this.runtime);
        sb.append(',');
        sb.append("allowConfiguration");
        sb.append('=');
        sb.append(this.allowConfiguration == null ? "<null>" : this.allowConfiguration);
        sb.append(',');
        sb.append("appConfiguration");
        sb.append('=');
        sb.append(this.appConfiguration == null ? "<null>" : this.appConfiguration);
        sb.append(',');
        sb.append("appLogoUrl");
        sb.append('=');
        sb.append(this.appLogoUrl == null ? "<null>" : this.appLogoUrl);
        sb.append(',');
        sb.append("appScreenshots");
        sb.append('=');
        sb.append(this.appScreenshots == null ? "<null>" : this.appScreenshots);
        sb.append(',');
        sb.append("system");
        sb.append('=');
        sb.append(this.system == null ? "<null>" : this.system);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.allowConfiguration == null ? 0 : this.allowConfiguration.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.runtime == null ? 0 : this.runtime.hashCode());
        result = result * 31 + (this.appLogoUrl == null ? 0 : this.appLogoUrl.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.className == null ? 0 : this.className.hashCode());
        result = result * 31 + (this.permission == null ? 0 : this.permission.hashCode());
        result = result * 31 + (this.developerUrl == null ? 0 : this.developerUrl.hashCode());
        result = result * 31 + (this.appConfiguration == null ? 0 : this.appConfiguration.hashCode());
        result = result * 31 + (this.privacyPolicyUrl == null ? 0 : this.privacyPolicyUrl.hashCode());
        result = result * 31 + (this.appScreenshots == null ? 0 : this.appScreenshots.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sourcePythonClass == null ? 0 : this.sourcePythonClass.hashCode());
        result = result * 31 + (this.features == null ? 0 : this.features.hashCode());
        result = result * 31 + (this.supportEmail == null ? 0 : this.supportEmail.hashCode());
        result = result * 31 + (this.system == null ? 0 : this.system.hashCode());
        result = result * 31 + (this.scheduleType == null ? 0 : this.scheduleType.hashCode());
        result = result * 31 + (this.appType == null ? 0 : this.appType.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.developer == null ? 0 : this.developer.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateAppMarketPlaceDefinitionReq)) {
            return false;
        }
        CreateAppMarketPlaceDefinitionReq rhs = (CreateAppMarketPlaceDefinitionReq)other;
        return (this.allowConfiguration == rhs.allowConfiguration || this.allowConfiguration != null && this.allowConfiguration.equals(rhs.allowConfiguration)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.runtime == rhs.runtime || this.runtime != null && this.runtime.equals(rhs.runtime)) && (this.appLogoUrl == rhs.appLogoUrl || this.appLogoUrl != null && this.appLogoUrl.equals(rhs.appLogoUrl)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.className == rhs.className || this.className != null && this.className.equals(rhs.className)) && (this.permission == rhs.permission || this.permission != null && this.permission.equals((Object)rhs.permission)) && (this.developerUrl == rhs.developerUrl || this.developerUrl != null && this.developerUrl.equals(rhs.developerUrl)) && (this.appConfiguration == rhs.appConfiguration || this.appConfiguration != null && this.appConfiguration.equals(rhs.appConfiguration)) && (this.privacyPolicyUrl == rhs.privacyPolicyUrl || this.privacyPolicyUrl != null && this.privacyPolicyUrl.equals(rhs.privacyPolicyUrl)) && (this.appScreenshots == rhs.appScreenshots || this.appScreenshots != null && this.appScreenshots.equals(rhs.appScreenshots)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sourcePythonClass == rhs.sourcePythonClass || this.sourcePythonClass != null && this.sourcePythonClass.equals(rhs.sourcePythonClass)) && (this.features == rhs.features || this.features != null && this.features.equals(rhs.features)) && (this.supportEmail == rhs.supportEmail || this.supportEmail != null && this.supportEmail.equals(rhs.supportEmail)) && (this.system == rhs.system || this.system != null && this.system.equals(rhs.system)) && (this.scheduleType == rhs.scheduleType || this.scheduleType != null && this.scheduleType.equals((Object)rhs.scheduleType)) && (this.appType == rhs.appType || this.appType != null && this.appType.equals((Object)rhs.appType)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.developer == rhs.developer || this.developer != null && this.developer.equals(rhs.developer));
    }
}

