/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.entity.app.external.Resource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "resources", "actions"})
public class AutomatorAppConfig {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Application type.")
    @NotNull
    private AutomatorAppType type = AutomatorAppType.fromValue("Automator");
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Entities selected to run the automation.")
    @Valid
    @NotNull
    private Resource resources;
    @JsonProperty(value="actions")
    @JsonPropertyDescription(value="Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.")
    @Valid
    @NotNull
    private List<Object> actions = new ArrayList<Object>();

    @JsonProperty(value="type")
    public AutomatorAppType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AutomatorAppType type) {
        this.type = type;
    }

    public AutomatorAppConfig withType(AutomatorAppType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="resources")
    public Resource getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(Resource resources) {
        this.resources = resources;
    }

    public AutomatorAppConfig withResources(Resource resources) {
        this.resources = resources;
        return this;
    }

    @JsonProperty(value="actions")
    public List<Object> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    public void setActions(List<Object> actions) {
        this.actions = actions;
    }

    public AutomatorAppConfig withActions(List<Object> actions) {
        this.actions = actions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AutomatorAppConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("resources");
        sb.append('=');
        sb.append(this.resources == null ? "<null>" : this.resources);
        sb.append(',');
        sb.append("actions");
        sb.append('=');
        sb.append(this.actions == null ? "<null>" : this.actions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.resources == null ? 0 : this.resources.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AutomatorAppConfig)) {
            return false;
        }
        AutomatorAppConfig rhs = (AutomatorAppConfig)other;
        return (this.resources == rhs.resources || this.resources != null && this.resources.equals(rhs.resources)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.actions == rhs.actions || this.actions != null && this.actions.equals(rhs.actions));
    }

    public static enum AutomatorAppType {
        AUTOMATOR("Automator");

        private final String value;
        private static final Map<String, AutomatorAppType> CONSTANTS;

        private AutomatorAppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AutomatorAppType fromValue(String value) {
            AutomatorAppType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AutomatorAppType>();
            for (AutomatorAppType c : AutomatorAppType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

