/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "filter", "patchIfEmpty"})
public class CollateAIAppConfig {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Application type.")
    private CollateAIAppType type = CollateAIAppType.fromValue("CollateAI");
    @JsonProperty(value="filter")
    @JsonPropertyDescription(value="Query filter to be passed to ES. E.g., `{\"query\":{\"bool\":{\"must\":[{\"bool\":{\"should\":[{\"term\":{\"domain.displayName.keyword\":\"DG Anim\"}}]}}]}}}`. This is the same payload as in the Explore page.")
    @NotNull
    private String filter;
    @JsonProperty(value="patchIfEmpty")
    @JsonPropertyDescription(value="Patch the description if it is empty, instead of raising a suggestion")
    private Boolean patchIfEmpty = false;

    @JsonProperty(value="type")
    public CollateAIAppType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(CollateAIAppType type) {
        this.type = type;
    }

    public CollateAIAppConfig withType(CollateAIAppType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="filter")
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public CollateAIAppConfig withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty(value="patchIfEmpty")
    public Boolean getPatchIfEmpty() {
        return this.patchIfEmpty;
    }

    @JsonProperty(value="patchIfEmpty")
    public void setPatchIfEmpty(Boolean patchIfEmpty) {
        this.patchIfEmpty = patchIfEmpty;
    }

    public CollateAIAppConfig withPatchIfEmpty(Boolean patchIfEmpty) {
        this.patchIfEmpty = patchIfEmpty;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CollateAIAppConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(this.filter == null ? "<null>" : this.filter);
        sb.append(',');
        sb.append("patchIfEmpty");
        sb.append('=');
        sb.append(this.patchIfEmpty == null ? "<null>" : this.patchIfEmpty);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.filter == null ? 0 : this.filter.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.patchIfEmpty == null ? 0 : this.patchIfEmpty.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CollateAIAppConfig)) {
            return false;
        }
        CollateAIAppConfig rhs = (CollateAIAppConfig)other;
        return (this.filter == rhs.filter || this.filter != null && this.filter.equals(rhs.filter)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.patchIfEmpty == rhs.patchIfEmpty || this.patchIfEmpty != null && this.patchIfEmpty.equals(rhs.patchIfEmpty));
    }

    public static enum CollateAIAppType {
        COLLATE_AI("CollateAI");

        private final String value;
        private static final Map<String, CollateAIAppType> CONSTANTS;

        private CollateAIAppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CollateAIAppType fromValue(String value) {
            CollateAIAppType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CollateAIAppType>();
            for (CollateAIAppType c : CollateAIAppType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

