/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.app.external;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.entity.app.external.collateAI.CollateAILimits;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"waiiInstance", "collateURL", "token", "limits"})
public class CollateAIAppPrivateConfig {
    @JsonProperty(value="waiiInstance")
    @JsonPropertyDescription(value="WAII API host URL")
    @NotNull
    private String waiiInstance = "https://tweakit.waii.ai/api/";
    @JsonProperty(value="collateURL")
    @JsonPropertyDescription(value="Collate Server public URL. WAII will use this information to interact with the server. E.g., https://sandbox.getcollate.io")
    @NotNull
    private String collateURL;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="WAII API Token")
    @PasswordField
    @NotNull
    private String token;
    @JsonProperty(value="limits")
    @JsonPropertyDescription(value="Limits for the CollateAI Application.")
    @Valid
    @NotNull
    private CollateAILimits limits;

    @JsonProperty(value="waiiInstance")
    public String getWaiiInstance() {
        return this.waiiInstance;
    }

    @JsonProperty(value="waiiInstance")
    public void setWaiiInstance(String waiiInstance) {
        this.waiiInstance = waiiInstance;
    }

    public CollateAIAppPrivateConfig withWaiiInstance(String waiiInstance) {
        this.waiiInstance = waiiInstance;
        return this;
    }

    @JsonProperty(value="collateURL")
    public String getCollateURL() {
        return this.collateURL;
    }

    @JsonProperty(value="collateURL")
    public void setCollateURL(String collateURL) {
        this.collateURL = collateURL;
    }

    public CollateAIAppPrivateConfig withCollateURL(String collateURL) {
        this.collateURL = collateURL;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public CollateAIAppPrivateConfig withToken(String token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="limits")
    public CollateAILimits getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    public void setLimits(CollateAILimits limits) {
        this.limits = limits;
    }

    public CollateAIAppPrivateConfig withLimits(CollateAILimits limits) {
        this.limits = limits;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CollateAIAppPrivateConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("waiiInstance");
        sb.append('=');
        sb.append(this.waiiInstance == null ? "<null>" : this.waiiInstance);
        sb.append(',');
        sb.append("collateURL");
        sb.append('=');
        sb.append(this.collateURL == null ? "<null>" : this.collateURL);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("limits");
        sb.append('=');
        sb.append(this.limits == null ? "<null>" : this.limits);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.waiiInstance == null ? 0 : this.waiiInstance.hashCode());
        result = result * 31 + (this.collateURL == null ? 0 : this.collateURL.hashCode());
        result = result * 31 + (this.limits == null ? 0 : this.limits.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CollateAIAppPrivateConfig)) {
            return false;
        }
        CollateAIAppPrivateConfig rhs = (CollateAIAppPrivateConfig)other;
        return (this.waiiInstance == rhs.waiiInstance || this.waiiInstance != null && this.waiiInstance.equals(rhs.waiiInstance)) && (this.collateURL == rhs.collateURL || this.collateURL != null && this.collateURL.equals(rhs.collateURL)) && (this.limits == rhs.limits || this.limits != null && this.limits.equals(rhs.limits)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }
}

