/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.external.automator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "description", "applyToChildren", "overwriteMetadata"})
public class AddDescriptionAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Add Description Action Type.")
    @NotNull
    private AddDescriptionActionType type = AddDescriptionActionType.fromValue("AddDescriptionAction");
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description to apply")
    @NotNull
    private String description;
    @JsonProperty(value="applyToChildren")
    @JsonPropertyDescription(value="Apply the description to the children of the selected assets that match the criteria. E.g., columns, tasks, topic fields,...")
    @Valid
    private List<String> applyToChildren = null;
    @JsonProperty(value="overwriteMetadata")
    @JsonPropertyDescription(value="Update the description even if they are already defined in the asset. By default, we'll only add the descriptions to assets without the description set.")
    private Boolean overwriteMetadata = false;

    @JsonProperty(value="type")
    public AddDescriptionActionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AddDescriptionActionType type) {
        this.type = type;
    }

    public AddDescriptionAction withType(AddDescriptionActionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public AddDescriptionAction withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="applyToChildren")
    public List<String> getApplyToChildren() {
        return this.applyToChildren;
    }

    @JsonProperty(value="applyToChildren")
    public void setApplyToChildren(List<String> applyToChildren) {
        this.applyToChildren = applyToChildren;
    }

    public AddDescriptionAction withApplyToChildren(List<String> applyToChildren) {
        this.applyToChildren = applyToChildren;
        return this;
    }

    @JsonProperty(value="overwriteMetadata")
    public Boolean getOverwriteMetadata() {
        return this.overwriteMetadata;
    }

    @JsonProperty(value="overwriteMetadata")
    public void setOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
    }

    public AddDescriptionAction withOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddDescriptionAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("applyToChildren");
        sb.append('=');
        sb.append(this.applyToChildren == null ? "<null>" : this.applyToChildren);
        sb.append(',');
        sb.append("overwriteMetadata");
        sb.append('=');
        sb.append(this.overwriteMetadata == null ? "<null>" : this.overwriteMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.applyToChildren == null ? 0 : this.applyToChildren.hashCode());
        result = result * 31 + (this.overwriteMetadata == null ? 0 : this.overwriteMetadata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddDescriptionAction)) {
            return false;
        }
        AddDescriptionAction rhs = (AddDescriptionAction)other;
        return (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.applyToChildren == rhs.applyToChildren || this.applyToChildren != null && this.applyToChildren.equals(rhs.applyToChildren)) && (this.overwriteMetadata == rhs.overwriteMetadata || this.overwriteMetadata != null && this.overwriteMetadata.equals(rhs.overwriteMetadata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum AddDescriptionActionType {
        ADD_DESCRIPTION_ACTION("AddDescriptionAction");

        private final String value;
        private static final Map<String, AddDescriptionActionType> CONSTANTS;

        private AddDescriptionActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AddDescriptionActionType fromValue(String value) {
            AddDescriptionActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AddDescriptionActionType>();
            for (AddDescriptionActionType c : AddDescriptionActionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

