/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.external.automator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "domain", "overwriteMetadata"})
public class AddDomainAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Add Owner Action Type.")
    @NotNull
    private AddDomainActionType type = AddDomainActionType.fromValue("AddDomainAction");
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference domain;
    @JsonProperty(value="overwriteMetadata")
    @JsonPropertyDescription(value="Update the domain even if it is defined in the asset. By default, we will only apply the domain to assets without domain.")
    private Boolean overwriteMetadata = false;

    @JsonProperty(value="type")
    public AddDomainActionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AddDomainActionType type) {
        this.type = type;
    }

    public AddDomainAction withType(AddDomainActionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public AddDomainAction withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="overwriteMetadata")
    public Boolean getOverwriteMetadata() {
        return this.overwriteMetadata;
    }

    @JsonProperty(value="overwriteMetadata")
    public void setOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
    }

    public AddDomainAction withOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddDomainAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("overwriteMetadata");
        sb.append('=');
        sb.append(this.overwriteMetadata == null ? "<null>" : this.overwriteMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.overwriteMetadata == null ? 0 : this.overwriteMetadata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddDomainAction)) {
            return false;
        }
        AddDomainAction rhs = (AddDomainAction)other;
        return (this.overwriteMetadata == rhs.overwriteMetadata || this.overwriteMetadata != null && this.overwriteMetadata.equals(rhs.overwriteMetadata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain));
    }

    public static enum AddDomainActionType {
        ADD_DOMAIN_ACTION("AddDomainAction");

        private final String value;
        private static final Map<String, AddDomainActionType> CONSTANTS;

        private AddDomainActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AddDomainActionType fromValue(String value) {
            AddDomainActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AddDomainActionType>();
            for (AddDomainActionType c : AddDomainActionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

