/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.external.automator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "owners", "overwriteMetadata"})
public class AddOwnerAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Add Owner Action Type.")
    @NotNull
    private AddOwnerActionType type = AddOwnerActionType.fromValue("AddOwnerAction");
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private List<EntityReference> owners = null;
    @JsonProperty(value="overwriteMetadata")
    @JsonPropertyDescription(value="Update the owners even if it is defined in the asset. By default, we will only apply the owners to assets without owner.")
    private Boolean overwriteMetadata = false;

    @JsonProperty(value="type")
    public AddOwnerActionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AddOwnerActionType type) {
        this.type = type;
    }

    public AddOwnerAction withType(AddOwnerActionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public AddOwnerAction withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="overwriteMetadata")
    public Boolean getOverwriteMetadata() {
        return this.overwriteMetadata;
    }

    @JsonProperty(value="overwriteMetadata")
    public void setOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
    }

    public AddOwnerAction withOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddOwnerAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("overwriteMetadata");
        sb.append('=');
        sb.append(this.overwriteMetadata == null ? "<null>" : this.overwriteMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.overwriteMetadata == null ? 0 : this.overwriteMetadata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddOwnerAction)) {
            return false;
        }
        AddOwnerAction rhs = (AddOwnerAction)other;
        return (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.overwriteMetadata == rhs.overwriteMetadata || this.overwriteMetadata != null && this.overwriteMetadata.equals(rhs.overwriteMetadata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum AddOwnerActionType {
        ADD_OWNER_ACTION("AddOwnerAction");

        private final String value;
        private static final Map<String, AddOwnerActionType> CONSTANTS;

        private AddOwnerActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AddOwnerActionType fromValue(String value) {
            AddOwnerActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AddOwnerActionType>();
            for (AddOwnerActionType c : AddOwnerActionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

