/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.external.automator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "tags", "applyToChildren", "overwriteMetadata"})
public class AddTagsAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Add Tags action type.")
    @NotNull
    private AddTagsActionType type = AddTagsActionType.fromValue("AddTagsAction");
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags to apply")
    @Valid
    @NotNull
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    @JsonProperty(value="applyToChildren")
    @JsonPropertyDescription(value="Apply tags to the children of the selected assets that match the criteria. E.g., columns, tasks, topic fields,...")
    @Valid
    private List<String> applyToChildren = null;
    @JsonProperty(value="overwriteMetadata")
    @JsonPropertyDescription(value="Update tags even if they are already defined in the asset. By default, incoming tags are merged with the existing ones.")
    private Boolean overwriteMetadata = false;

    @JsonProperty(value="type")
    public AddTagsActionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AddTagsActionType type) {
        this.type = type;
    }

    public AddTagsAction withType(AddTagsActionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public AddTagsAction withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="applyToChildren")
    public List<String> getApplyToChildren() {
        return this.applyToChildren;
    }

    @JsonProperty(value="applyToChildren")
    public void setApplyToChildren(List<String> applyToChildren) {
        this.applyToChildren = applyToChildren;
    }

    public AddTagsAction withApplyToChildren(List<String> applyToChildren) {
        this.applyToChildren = applyToChildren;
        return this;
    }

    @JsonProperty(value="overwriteMetadata")
    public Boolean getOverwriteMetadata() {
        return this.overwriteMetadata;
    }

    @JsonProperty(value="overwriteMetadata")
    public void setOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
    }

    public AddTagsAction withOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddTagsAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("applyToChildren");
        sb.append('=');
        sb.append(this.applyToChildren == null ? "<null>" : this.applyToChildren);
        sb.append(',');
        sb.append("overwriteMetadata");
        sb.append('=');
        sb.append(this.overwriteMetadata == null ? "<null>" : this.overwriteMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.applyToChildren == null ? 0 : this.applyToChildren.hashCode());
        result = result * 31 + (this.overwriteMetadata == null ? 0 : this.overwriteMetadata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddTagsAction)) {
            return false;
        }
        AddTagsAction rhs = (AddTagsAction)other;
        return (this.applyToChildren == rhs.applyToChildren || this.applyToChildren != null && this.applyToChildren.equals(rhs.applyToChildren)) && (this.overwriteMetadata == rhs.overwriteMetadata || this.overwriteMetadata != null && this.overwriteMetadata.equals(rhs.overwriteMetadata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }

    public static enum AddTagsActionType {
        ADD_TAGS_ACTION("AddTagsAction");

        private final String value;
        private static final Map<String, AddTagsActionType> CONSTANTS;

        private AddTagsActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AddTagsActionType fromValue(String value) {
            AddTagsActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AddTagsActionType>();
            for (AddTagsActionType c : AddTagsActionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

