/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.external.automator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "tier", "overwriteMetadata"})
public class AddTierAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Add Tier Action Type.")
    @NotNull
    private AddTierActionType type = AddTierActionType.fromValue("AddTierAction");
    @JsonProperty(value="tier")
    @JsonPropertyDescription(value="This schema defines the type for labeling an entity with a Tag.")
    @Valid
    @NotNull
    private TagLabel tier;
    @JsonProperty(value="overwriteMetadata")
    @JsonPropertyDescription(value="Update the tier even if it is defined in the asset. By default, we will only apply the tier to assets without tier.")
    private Boolean overwriteMetadata = false;

    @JsonProperty(value="type")
    public AddTierActionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AddTierActionType type) {
        this.type = type;
    }

    public AddTierAction withType(AddTierActionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="tier")
    public TagLabel getTier() {
        return this.tier;
    }

    @JsonProperty(value="tier")
    public void setTier(TagLabel tier) {
        this.tier = tier;
    }

    public AddTierAction withTier(TagLabel tier) {
        this.tier = tier;
        return this;
    }

    @JsonProperty(value="overwriteMetadata")
    public Boolean getOverwriteMetadata() {
        return this.overwriteMetadata;
    }

    @JsonProperty(value="overwriteMetadata")
    public void setOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
    }

    public AddTierAction withOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddTierAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("tier");
        sb.append('=');
        sb.append(this.tier == null ? "<null>" : this.tier);
        sb.append(',');
        sb.append("overwriteMetadata");
        sb.append('=');
        sb.append(this.overwriteMetadata == null ? "<null>" : this.overwriteMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.overwriteMetadata == null ? 0 : this.overwriteMetadata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.tier == null ? 0 : this.tier.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddTierAction)) {
            return false;
        }
        AddTierAction rhs = (AddTierAction)other;
        return (this.overwriteMetadata == rhs.overwriteMetadata || this.overwriteMetadata != null && this.overwriteMetadata.equals(rhs.overwriteMetadata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.tier == rhs.tier || this.tier != null && this.tier.equals(rhs.tier));
    }

    public static enum AddTierActionType {
        ADD_TIER_ACTION("AddTierAction");

        private final String value;
        private static final Map<String, AddTierActionType> CONSTANTS;

        private AddTierActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AddTierActionType fromValue(String value) {
            AddTierActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AddTierActionType>();
            for (AddTierActionType c : AddTierActionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

