/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.external.automator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "overwriteMetadata"})
public class LineagePropagationAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Lineage propagation action type.")
    @NotNull
    private LineagePropagationActionType type = LineagePropagationActionType.fromValue("LineagePropagationAction");
    @JsonProperty(value="overwriteMetadata")
    @JsonPropertyDescription(value="Update descriptions and tags via lineage even if they are already defined in the asset. By default, descriptions are only updated if they are not already defined in the asset, and incoming tags are merged with the existing ones.")
    private Boolean overwriteMetadata = false;

    @JsonProperty(value="type")
    public LineagePropagationActionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(LineagePropagationActionType type) {
        this.type = type;
    }

    public LineagePropagationAction withType(LineagePropagationActionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="overwriteMetadata")
    public Boolean getOverwriteMetadata() {
        return this.overwriteMetadata;
    }

    @JsonProperty(value="overwriteMetadata")
    public void setOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
    }

    public LineagePropagationAction withOverwriteMetadata(Boolean overwriteMetadata) {
        this.overwriteMetadata = overwriteMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LineagePropagationAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("overwriteMetadata");
        sb.append('=');
        sb.append(this.overwriteMetadata == null ? "<null>" : this.overwriteMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.overwriteMetadata == null ? 0 : this.overwriteMetadata.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LineagePropagationAction)) {
            return false;
        }
        LineagePropagationAction rhs = (LineagePropagationAction)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.overwriteMetadata == rhs.overwriteMetadata || this.overwriteMetadata != null && this.overwriteMetadata.equals(rhs.overwriteMetadata));
    }

    public static enum LineagePropagationActionType {
        LINEAGE_PROPAGATION_ACTION("LineagePropagationAction");

        private final String value;
        private static final Map<String, LineagePropagationActionType> CONSTANTS;

        private LineagePropagationActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LineagePropagationActionType fromValue(String value) {
            LineagePropagationActionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, LineagePropagationActionType>();
            for (LineagePropagationActionType c : LineagePropagationActionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

