/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.entity.applications.configuration.internal.BackfillConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "batchSize", "recreateDataAssetsIndex", "backfillConfiguration"})
public class DataInsightsAppConfig {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Application Type")
    private DataInsightsAppType type = DataInsightsAppType.fromValue("DataInsights");
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events processed at a time (Default 100).")
    private Integer batchSize = 100;
    @JsonProperty(value="recreateDataAssetsIndex")
    @JsonPropertyDescription(value="Recreates the DataAssets index on DataInsights. Useful if you changed a Custom Property Type and are facing errors. Bear in mind that recreating the index will delete your DataAssets and a backfill will be needed.")
    private Boolean recreateDataAssetsIndex = false;
    @JsonProperty(value="backfillConfiguration")
    @JsonPropertyDescription(value="Backfill Configuration")
    @Valid
    private BackfillConfiguration backfillConfiguration;

    @JsonProperty(value="type")
    public DataInsightsAppType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DataInsightsAppType type) {
        this.type = type;
    }

    public DataInsightsAppConfig withType(DataInsightsAppType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public DataInsightsAppConfig withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="recreateDataAssetsIndex")
    public Boolean getRecreateDataAssetsIndex() {
        return this.recreateDataAssetsIndex;
    }

    @JsonProperty(value="recreateDataAssetsIndex")
    public void setRecreateDataAssetsIndex(Boolean recreateDataAssetsIndex) {
        this.recreateDataAssetsIndex = recreateDataAssetsIndex;
    }

    public DataInsightsAppConfig withRecreateDataAssetsIndex(Boolean recreateDataAssetsIndex) {
        this.recreateDataAssetsIndex = recreateDataAssetsIndex;
        return this;
    }

    @JsonProperty(value="backfillConfiguration")
    public BackfillConfiguration getBackfillConfiguration() {
        return this.backfillConfiguration;
    }

    @JsonProperty(value="backfillConfiguration")
    public void setBackfillConfiguration(BackfillConfiguration backfillConfiguration) {
        this.backfillConfiguration = backfillConfiguration;
    }

    public DataInsightsAppConfig withBackfillConfiguration(BackfillConfiguration backfillConfiguration) {
        this.backfillConfiguration = backfillConfiguration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataInsightsAppConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("recreateDataAssetsIndex");
        sb.append('=');
        sb.append(this.recreateDataAssetsIndex == null ? "<null>" : this.recreateDataAssetsIndex);
        sb.append(',');
        sb.append("backfillConfiguration");
        sb.append('=');
        sb.append(this.backfillConfiguration == null ? "<null>" : this.backfillConfiguration);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.backfillConfiguration == null ? 0 : this.backfillConfiguration.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.recreateDataAssetsIndex == null ? 0 : this.recreateDataAssetsIndex.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataInsightsAppConfig)) {
            return false;
        }
        DataInsightsAppConfig rhs = (DataInsightsAppConfig)other;
        return (this.backfillConfiguration == rhs.backfillConfiguration || this.backfillConfiguration != null && this.backfillConfiguration.equals(rhs.backfillConfiguration)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.recreateDataAssetsIndex == rhs.recreateDataAssetsIndex || this.recreateDataAssetsIndex != null && this.recreateDataAssetsIndex.equals(rhs.recreateDataAssetsIndex));
    }

    public static enum DataInsightsAppType {
        DATA_INSIGHTS("DataInsights");

        private final String value;
        private static final Map<String, DataInsightsAppType> CONSTANTS;

        private DataInsightsAppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataInsightsAppType fromValue(String value) {
            DataInsightsAppType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DataInsightsAppType>();
            for (DataInsightsAppType c : DataInsightsAppType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

